/*
 * Decompiled with CFR 0.152.
 */
package ruplib.canvas;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JPanel;
import ruplib.geom.IMovable;
import ruplib.util.IO;
import ruplib.util.NamedColor;

public final class Canvas
implements IMovable {
    public static final int DEFAULT_STEP = 50;
    public static final int MAX_STEP = 200;
    private static final String CONFIG_PATH = "bluej/win_settings.properties";
    private static final String TITLE = "Jednoduch\u00e9 pl\u00e1tno";
    public static final int WIDTH_0 = 300;
    public static final int HEIGHT_0 = 300;
    public static final NamedColor BACKGROUND_0 = NamedColor.CREAMY;
    public static final Point POINT_0 = new Point(0, 0);
    private static InitCrate initCrate;
    private static volatile boolean initialized;
    private static int step;
    private final JFrame appWindow;
    private final JPanel canvasContainer;
    private Image canvasImage;
    private Graphics2D painter;
    private NamedColor backgroundColor = BACKGROUND_0;
    private int width;
    private int height;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Canvas getInstance() {
        if (!initialized) {
            Class<Canvas> clazz = Canvas.class;
            // MONITORENTER : ruplib.canvas.Canvas.class
            if (!initialized) {
                Canvas.initialize();
            }
            // MONITOREXIT : clazz
        }
        Holder.CANVAS.setVisible(true);
        return Holder.CANVAS;
    }

    public static int getDefaultStep() {
        return 50;
    }

    public static void setDefaultStep() {
        step = 50;
    }

    public static int getStep() {
        return step;
    }

    public static void setStep(int n) {
        if (n < 0 || n > 200) {
            throw new IllegalArgumentException("\nThe distance must be from inteval <0; 200>.");
        }
        step = n;
    }

    public static void clearCanvas() {
        Holder.CANVAS.clear();
    }

    public static void showCanvas() {
        Canvas.getInstance().setVisible(true);
    }

    private static void configurationFromFile() {
        Properties properties = System.getProperties();
        String string = properties.getProperty("user.home");
        File file = new File(string, CONFIG_PATH);
        Properties properties2 = new Properties();
        try {
            try (FileReader fileReader = new FileReader(file);){
                properties2.load(fileReader);
            }
            initCrate = new InitCrate(Canvas.xyPropery(properties2, ""), Canvas.xyPropery(properties2, "d"));
        }
        catch (IOException | NumberFormatException exception) {
            initCrate = new InitCrate(POINT_0, POINT_0);
        }
    }

    private static void initialize() {
        Canvas.configurationFromFile();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Holder.CANVAS = new Canvas();
            }
        };
        try {
            EventQueue.invokeAndWait(runnable);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            stringWriter.write("\nCreation of CanvasManager didn't succeed\n");
            exception.printStackTrace(printWriter);
            String string = stringWriter.toString();
            System.err.println(string);
            IO.inform(string);
            System.exit(1);
        }
        Canvas canvas = Holder.CANVAS;
        int n = canvas.appWindow.getX();
        int n2 = canvas.appWindow.getY() + canvas.appWindow.getHeight();
        IO.setDialogsPosition(n, n2);
        initialized = true;
    }

    private static Point xyPropery(Properties properties, String string) throws NumberFormatException {
        String string2 = properties.getProperty("canvas." + string + "x");
        String string3 = properties.getProperty("canvas." + string + "y");
        int n = Integer.parseInt(string2.trim());
        int n2 = Integer.parseInt(string3.trim());
        Point point = new Point(n, n2);
        return point;
    }

    private Canvas() {
        this.appWindow = new JFrame();
        this.appWindow.setLocation(Canvas.initCrate.point);
        this.appWindow.setTitle(TITLE);
        this.appWindow.setDefaultCloseOperation(3);
        this.canvasContainer = new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                graphics.drawImage(Canvas.this.canvasImage, 0, 0, null);
            }
        };
        this.appWindow.setContentPane(this.canvasContainer);
        this.setSizePrivate(300, 300);
        IO.setDialogsPosition(Canvas.initCrate.point.x, Canvas.initCrate.point.y + this.appWindow.getSize().height);
    }

    public NamedColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(NamedColor namedColor) {
        this.backgroundColor = namedColor;
        this.painter.setBackground(namedColor.getAWTColor());
        this.clear();
    }

    public String getTitle() {
        return this.appWindow.getTitle();
    }

    public void setTitle(String string) {
        this.appWindow.setTitle(string);
    }

    @Override
    public int getX() {
        return this.appWindow.getX();
    }

    @Override
    public int getY() {
        return this.appWindow.getY();
    }

    @Override
    public void setPosition(int n, int n2) {
        this.appWindow.setLocation(n, n2);
        this.setVisible(true);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setSize(int n, int n2) {
        this.setSizePrivate(n, n2);
    }

    public boolean isVisible() {
        return this.appWindow.isVisible();
    }

    public void setVisible(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.isVisible() != bl;
        if (bl2) {
            if (!bl) {
                this.appWindow.setVisible(false);
            } else {
                if (EventQueue.isDispatchThread()) {
                    this.setVisibleInternal();
                    return;
                }
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Canvas.this.setVisibleInternal();
                    }
                };
                try {
                    EventQueue.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    throw new RuntimeException("\nException by visibilty setting", exception);
                }
            }
        }
    }

    public void clear() {
        this.erase(new Rectangle2D.Double(0.0, 0.0, this.width, this.height));
    }

    public void drawLine(int n, int n2, int n3, int n4, NamedColor namedColor) {
        this.setForegroundColor(namedColor);
        this.painter.drawLine(n, n2, n3, n4);
        this.canvasContainer.repaint();
    }

    public void drawString(String string, int n, int n2, NamedColor namedColor) {
        this.setForegroundColor(namedColor);
        this.painter.drawString(string, n, n2);
        this.canvasContainer.repaint();
    }

    public void erase(Shape shape) {
        Color color = this.painter.getColor();
        this.painter.setColor(this.backgroundColor.getAWTColor());
        this.painter.fill(shape);
        this.painter.setColor(color);
        this.canvasContainer.repaint();
    }

    public void fill(Shape shape, NamedColor namedColor) {
        this.setForegroundColor(namedColor);
        this.painter.fill(shape);
        this.canvasContainer.repaint();
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.width + "x" + this.height + " na pozici [" + this.getX() + "; " + this.getY() + "], pozadi=" + String.valueOf(this.backgroundColor) + ")";
    }

    private void prepareImage() {
        this.canvasImage = this.canvasContainer.createImage(this.width, this.height);
        this.painter = (Graphics2D)this.canvasImage.getGraphics();
        this.painter.setColor(this.backgroundColor.getAWTColor());
        this.painter.fillRect(0, 0, this.width, this.height);
        this.painter.setColor(Color.BLACK);
    }

    private void setForegroundColor(NamedColor namedColor) {
        this.painter.setColor(namedColor.getAWTColor());
    }

    private void setSizePrivate(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.appWindow.setResizable(true);
        this.canvasContainer.setPreferredSize(new Dimension(n, n2));
        this.appWindow.pack();
        Insets insets = this.appWindow.getInsets();
        if (Canvas.initCrate.inset.y == 0) {
            Canvas.initCrate.inset.x = insets.left + insets.right;
            Canvas.initCrate.inset.y = insets.top + insets.bottom;
        }
        this.appWindow.setSize(n + Canvas.initCrate.inset.x, n2 + Canvas.initCrate.inset.y);
        this.appWindow.setResizable(false);
        this.setVisible(true);
        this.prepareImage();
        this.clear();
    }

    private void setVisibleInternal() {
        Canvas.initCrate.point = this.appWindow.getLocation();
        this.appWindow.setVisible(true);
        this.appWindow.setLocation(Canvas.initCrate.point);
        this.appWindow.setAlwaysOnTop(true);
        this.appWindow.toFront();
        this.appWindow.setAlwaysOnTop(false);
    }

    static {
        initialized = false;
        step = 50;
    }

    private static class Holder {
        static volatile Canvas CANVAS;

        private Holder() {
        }
    }

    private static class InitCrate {
        Point point;
        Point inset;

        public InitCrate(Point point, Point point2) {
            this.point = point;
            this.inset = point2;
        }
    }
}

