/*
 * Decompiled with CFR 0.152.
 */
package ruplib.canvasmanager;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import ruplib.canvasmanager.IAdaptable;
import ruplib.canvasmanager.ICMPaintable;
import ruplib.canvasmanager.Line;
import ruplib.canvasmanager.Painter;
import ruplib.canvasmanager.Picture;
import ruplib.geom.IChangeable;
import ruplib.geom.IModular;
import ruplib.geom.IMovable;
import ruplib.geom.Position;
import ruplib.geom.Size;
import ruplib.util.IO;
import ruplib.util.NamedColor;

public final class CanvasManager {
    private static final String TITLE_0 = "Managed canvas";
    private static final int WIDTH_0 = 6;
    private static final int HEIGHT_0 = 6;
    private static final NamedColor BACKGROUNG_0 = NamedColor.CREAMY;
    private static final NamedColor GRID_COLOR_0 = NamedColor.BLACK;
    private static final int STEP_0 = 50;
    private static final int MAX_FIELD_SIZE = 200;
    private static final String CONFIG_PATH = "bluej/win_setting.properties";
    private static volatile CanvasManager CM;
    private final JFrame window;
    private final JPanel canvas;
    private final List<ICMPaintable> paintedObjects = new ArrayList<ICMPaintable>();
    private final Insets insets;
    private Image canvasImage;
    private Painter painter;
    private int drawLevel = 0;
    private boolean drawing = false;
    private Line[] horizontals;
    private Line[] verticals;
    private int step = 50;
    private int showGrid = -1;
    private NamedColor backgroundColor = BACKGROUNG_0;
    private NamedColor gridColor = GRID_COLOR_0;
    private int columns = 6;
    private int rows = 6;
    private int width = 6 * this.step;
    private int height = 6 * this.step;
    private boolean notifySizeChanges = true;
    private Object sizeOwner = null;
    Point position;

    public static CanvasManager getInstance() {
        return CanvasManager.getInstance(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static CanvasManager getInstance(boolean bl) {
        if (CM == null) {
            Class<CanvasManager> clazz = CanvasManager.class;
            // MONITORENTER : ruplib.canvasmanager.CanvasManager.class
            if (CM == null) {
                CanvasManager.initialize();
                if (bl) {
                    CM.repaint();
                }
            }
            // MONITOREXIT : clazz
        }
        if (!bl) return CM;
        CM.setVisible(true);
        CM.repaint();
        return CM;
    }

    private static void invokeAndWait(Runnable runnable, String string) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
            return;
        }
        try {
            EventQueue.invokeAndWait(runnable);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            throw new RuntimeException("\nSpu\u0161t\u011bn\u00ed akce \u00ab" + string + "\u00bb ve front\u011b ud\u00e1lost\u00ed se nezda\u0159ilo", exception);
        }
    }

    private static Point configurationFromFile() {
        Point point;
        Properties properties = System.getProperties();
        String string = properties.getProperty("user.home");
        File file = new File(string, CONFIG_PATH);
        Properties properties2 = new Properties();
        try {
            try (Object object = new FileReader(file);){
                properties2.load((Reader)object);
            }
            object = properties2.getProperty("canvas.x");
            String string2 = properties2.getProperty("canvas.y");
            int n = Integer.parseInt(properties2.getProperty("canvas.x").trim());
            int n2 = Integer.parseInt(properties2.getProperty("canvas.y").trim());
            point = new Point(n, n2);
        }
        catch (IOException | NumberFormatException exception) {
            point = new Point(0, 0);
        }
        return point;
    }

    private static void initialize() {
        final Point point = CanvasManager.configurationFromFile();
        final Holder holder = new Holder();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CanvasManager.prepareCM(point, holder);
            }
        };
        try {
            EventQueue.invokeAndWait(runnable);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            stringWriter.write("\nCreation of CanvasManager doesn't succeed\n");
            exception.printStackTrace(printWriter);
            String string = stringWriter.toString();
            System.err.println(string);
            JOptionPane.showMessageDialog(null, string);
            System.exit(1);
        }
        CanvasManager canvasManager = holder.manager;
        int n = canvasManager.window.getX();
        int n2 = canvasManager.window.getY() + canvasManager.window.getHeight();
        IO.setDialogsPosition(n, n2);
        CM = canvasManager;
        CM.prepareGrid();
    }

    private static void prepareCM(Point point, Holder holder) {
        CanvasManager canvasManager = new CanvasManager();
        canvasManager.setName(TITLE_0);
        canvasManager.setPosition(point.x, point.y);
        canvasManager.setStepAndSizeInternal(50, 6, 6);
        holder.manager = canvasManager;
    }

    private CanvasManager() {
        this.window = new JFrame();
        this.window.setDefaultCloseOperation(3);
        this.canvas = new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                graphics.drawImage(CanvasManager.this.canvasImage, 0, 0, null);
            }
        };
        this.window.setContentPane(this.canvas);
        this.window.pack();
        this.insets = this.window.getInsets();
    }

    public int getMaxStep() {
        return this.getMaxStepFor(this.columns, this.rows);
    }

    public int getMaxStepFor(int n, int n2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = (dimension.width - this.insets.left - this.insets.right) / n;
        int n4 = (dimension.height - this.insets.top - this.insets.bottom) / n2;
        return Math.min(n3, n4);
    }

    public int getMaxcColumns() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width - this.insets.left - this.insets.right;
        return n / this.step;
    }

    public int getMaxRows() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.height - this.insets.top - this.insets.bottom;
        return n / this.step;
    }

    public void setStepAndSize(int n, int n2, int n3) {
        this.setStepAndSize(n, n2, n3, null);
    }

    public synchronized void setStepAndSize(final int n, final int n2, final int n3, Object object) {
        this.setStepAndSizeCheckArgs(n, n2, n3, object);
        this.stopPainting();
        int n4 = this.step;
        CanvasManager.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                CanvasManager.this.setStepAndSizeInternal(n, n2, n3);
            }
        }, "setStepAndSizeInternal from setStepAndSize");
        this.prepareGrid();
        this.returnPainting();
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int n) {
        this.setStepAndSize(n, this.columns, this.rows);
    }

    public void setStepToMax() {
        this.setStepAndSize(this.getMaxStep(), this.columns, this.rows);
    }

    public int getColumns() {
        return this.columns;
    }

    public int getWidth() {
        return this.width;
    }

    public int getRows() {
        return this.rows;
    }

    public int getHeight() {
        return this.height;
    }

    public Size getSize() {
        return new Size(this.columns, this.rows);
    }

    public void setSize(int n, int n2) {
        this.setStepAndSize(this.step, n, n2);
    }

    public void setSize(Size size) {
        this.setSize(size.width, size.height);
    }

    public boolean isGridVisible() {
        return this.showGrid != 0;
    }

    public synchronized void setGridVisible(boolean bl) {
        this.setGridVisible(bl, false);
    }

    public synchronized void setGridVisible(boolean bl, boolean bl2) {
        this.showGrid = bl ? (bl2 ? 1 : -1) : 0;
        this.prepareGrid();
        this.repaint();
    }

    public NamedColor getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(NamedColor namedColor) {
        this.gridColor = namedColor;
    }

    public boolean isVisible() {
        return this.window.isVisible();
    }

    public synchronized void setVisible(final boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        boolean bl4 = bl2 = this.isVisible() != bl;
        if (!bl2) {
            return;
        }
        if (!bl) {
            this.window.setVisible(false);
            return;
        }
        this.position = this.window.getLocation();
        if (EventQueue.isDispatchThread()) {
            this.setVisibleInternal(bl);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    CanvasManager.this.setVisibleInternal(bl);
                }
            };
            EventQueue.invokeLater(runnable);
        }
    }

    public NamedColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public synchronized void setBackgroundColor(NamedColor namedColor) {
        this.backgroundColor = namedColor;
        this.painter.setBackground(this.backgroundColor);
        this.repaint();
    }

    public int getDrawLevel() {
        return this.drawLevel;
    }

    public String getName() {
        return this.window.getTitle();
    }

    public void setName(String string) {
        this.window.setTitle(string);
    }

    public Position getPosition() {
        return new Position(this.window.getX(), this.window.getY());
    }

    public synchronized void setPosition(int n, int n2) {
        this.window.setLocation(n, n2);
        IO.Correction.windowLocation(this.window);
        this.position = new Point(n, n2);
    }

    public void setPosition(Position position) {
        this.window.setLocation(position.x, position.y);
    }

    public Picture getPicture(int n, int n2, int n3, int n4) {
        BufferedImage bufferedImage = this.getBufferedImage(n, n2, n3, n4);
        return new Picture(0, 0, bufferedImage);
    }

    public String toString() {
        return this.getClass().getName() + "(step=" + this.step + ", width=" + this.columns + ", height=" + this.rows + ", background=" + String.valueOf(this.backgroundColor) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint() {
        if (this.drawing) {
            return;
        }
        if (this.drawLevel == 0 && this.isVisible()) {
            this.drawing = true;
            JPanel jPanel = this.canvas;
            synchronized (jPanel) {
                this.painter.fillRectangle(0, 0, this.width, this.height, this.backgroundColor);
                if (this.showGrid < 0 && this.gridColor != this.backgroundColor) {
                    this.drawGrid();
                }
                for (ICMPaintable iCMPaintable : this.paintedObjects) {
                    iCMPaintable.paint(this.painter);
                }
                if (this.showGrid > 0) {
                    this.drawGrid();
                }
            }
            this.canvas.repaint();
            this.drawing = false;
        }
    }

    public synchronized void stopPainting() {
        ++this.drawLevel;
    }

    public synchronized void returnPainting() {
        if (this.drawLevel == 0) {
            throw new IllegalStateException("Vr\u00e1cen\u00ed do stavu kreslen\u00ed mus\u00ed p\u0159ech\u00e1zet z\u00e1kaz!");
        }
        --this.drawLevel;
        if (this.drawLevel == 0) {
            this.repaint();
        }
    }

    public synchronized boolean remove(ICMPaintable iCMPaintable) {
        boolean bl = this.paintedObjects.remove(iCMPaintable);
        if (bl) {
            this.repaint();
        }
        return bl;
    }

    public void removeAll() {
        this.stopPainting();
        ListIterator<ICMPaintable> listIterator = this.paintedObjects.listIterator();
        while (listIterator.hasNext()) {
            listIterator.next();
            listIterator.remove();
        }
        this.returnPainting();
    }

    public synchronized int add(ICMPaintable ... iCMPaintableArray) {
        int n = 0;
        this.stopPainting();
        for (ICMPaintable iCMPaintable : iCMPaintableArray) {
            if (this.paintedObjects.contains(iCMPaintable)) continue;
            this.paintedObjects.add(iCMPaintable);
            ++n;
        }
        this.returnPainting();
        this.setVisible(true);
        return n;
    }

    public synchronized boolean addAbove(ICMPaintable iCMPaintable, ICMPaintable iCMPaintable2) {
        boolean bl = !this.paintedObjects.remove(iCMPaintable2);
        int n = this.paintedObjects.indexOf(iCMPaintable);
        if (n < 0) {
            throw new IllegalArgumentException("Referen\u010dn\u00ed objekt nen\u00ed na pl\u00e1tn\u011b zobrazov\u00e1n!");
        }
        this.paintedObjects.add(n + 1, iCMPaintable2);
        this.repaint();
        this.setVisible(true);
        return bl;
    }

    public synchronized boolean addBehind(ICMPaintable iCMPaintable, ICMPaintable iCMPaintable2) {
        boolean bl = !this.paintedObjects.remove(iCMPaintable2);
        int n = this.paintedObjects.indexOf(iCMPaintable);
        if (n < 0) {
            throw new IllegalArgumentException("Referen\u010dn\u00ed objekt nen\u00ed na pl\u00e1tn\u011b zobrazov\u00e1n!");
        }
        this.paintedObjects.add(n, iCMPaintable2);
        this.repaint();
        this.setVisible(true);
        return bl;
    }

    public synchronized boolean addToFront(ICMPaintable iCMPaintable) {
        boolean bl = !this.paintedObjects.remove(iCMPaintable);
        this.paintedObjects.add(iCMPaintable);
        this.repaint();
        this.setVisible(true);
        return bl;
    }

    public synchronized boolean addToBack(ICMPaintable iCMPaintable) {
        boolean bl = !this.paintedObjects.remove(iCMPaintable);
        this.paintedObjects.add(0, iCMPaintable);
        this.repaint();
        this.setVisible(true);
        return bl;
    }

    public void changeTogether(Runnable runnable) {
        this.stopPainting();
        runnable.run();
        this.returnPainting();
    }

    public int getIndexOf(ICMPaintable iCMPaintable) {
        return this.paintedObjects.indexOf(iCMPaintable);
    }

    public List<ICMPaintable> listOfShapes() {
        return Collections.unmodifiableList(this.paintedObjects);
    }

    public int fieldIndexOf(int n) {
        int n2 = n >= 0 ? n / this.step : (n - this.step + 1) / this.step;
        return n2;
    }

    public int pixelIndexOf(int n) {
        int n2 = n * this.step;
        return n2;
    }

    public Position positionField2Point(Position position) {
        Position position2 = new Position(this.step * position.x, this.step * position.y);
        return position2;
    }

    public Position positionPoint2Field(Position position) {
        Position position2 = new Position(position.x / this.step, position.y / this.step);
        return position2;
    }

    public Size sizeField2Point(Size size) {
        Size size2 = new Size(this.step * size.width, this.step * size.height);
        return size2;
    }

    public Size sizePoint2Field(Size size) {
        Size size2 = new Size(size.width / this.step, size.height / this.step);
        return size2;
    }

    public boolean setNotifySizeChanges(boolean bl) {
        boolean bl2 = this.notifySizeChanges;
        this.notifySizeChanges = bl;
        return bl2;
    }

    public void addKeyboardListener(KeyListener keyListener) {
        this.window.addKeyListener(keyListener);
    }

    public void removeKeyboardListener(KeyListener keyListener) {
        this.window.removeKeyListener(keyListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.window.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.window.removeMouseListener(mouseListener);
    }

    public void saveAsPicture(File file) {
        BufferedImage bufferedImage = this.getBufferedImage();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        }
        catch (IOException iOException) {
            throw new RuntimeException("\nObraz aktivn\u00edho pl\u00e1tna se nepoda\u0159ilo ulo\u017eit do souboru " + String.valueOf(file), iOException);
        }
    }

    private void adaptChangeable(IChangeable iChangeable, double d) {
        this.adaptMoveable(iChangeable, d);
        Size size = iChangeable.getSize();
        int n = (int)((double)size.width * d);
        int n2 = (int)((double)size.height * d);
        iChangeable.setSize(n, n2);
    }

    private void adaptModular(IModular iModular, double d) {
        this.adaptMoveable(iModular, d);
        int n = iModular.getModule();
        int n2 = (int)((double)n * d);
        iModular.setModule(n2);
    }

    private void adaptMoveable(IMovable iMovable, double d) {
        Position position = iMovable.getPosition();
        int n = (int)((double)position.x * d);
        int n2 = (int)((double)position.y * d);
        iMovable.setPosition(n, n2);
    }

    private BufferedImage getBufferedImage() {
        if (this.canvasImage instanceof BufferedImage) {
            return (BufferedImage)this.canvasImage;
        }
        return this.getBufferedImage(0, 0, this.width, this.height);
    }

    private BufferedImage getBufferedImage(int n, int n2, int n3, int n4) {
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(this.canvasImage, -n, -n2, Painter.IMG_OBSERVER);
        return bufferedImage;
    }

    private void drawGrid() {
        if (this.step > 1) {
            int n = 0;
            while (n < this.columns) {
                this.verticals[n++].paint(this.painter);
            }
            n = 0;
            while (n < this.rows) {
                this.horizontals[n++].paint(this.painter);
            }
        }
    }

    private void informAdaptables(int n) {
        if (this.notifySizeChanges && n != this.step) {
            this.stopPainting();
            double d = (double)this.step / (double)n;
            this.listOfShapes().stream().forEach(iCMPaintable -> {
                if (iCMPaintable instanceof IAdaptable) {
                    ((IAdaptable)iCMPaintable).stepChanged(n, this.step);
                } else if (iCMPaintable instanceof IChangeable) {
                    this.adaptChangeable((IChangeable)((Object)iCMPaintable), d);
                } else if (iCMPaintable instanceof IMovable) {
                    this.adaptMoveable((IMovable)((Object)iCMPaintable), d);
                }
            });
            this.returnPainting();
        }
    }

    private void prepareGrid() {
        if (this.showGrid != 0 && this.step > 1) {
            if (this.verticals == null || this.verticals.length != this.columns) {
                this.verticals = new Line[this.columns];
            }
            if (this.horizontals == null || this.horizontals.length != this.rows) {
                this.horizontals = new Line[this.rows];
            }
            int n = 0;
            int n2 = this.step;
            while (n < this.columns) {
                this.verticals[n] = new Line(n2, 0, n2, this.height, this.gridColor);
                ++n;
                n2 += this.step;
            }
            n = 0;
            n2 = this.step;
            while (n < this.rows) {
                this.horizontals[n] = new Line(0, n2, this.width, n2, this.gridColor);
                ++n;
                n2 += this.step;
            }
        } else {
            this.verticals = null;
            this.horizontals = null;
        }
    }

    private void setStepAndSizeCheckArgs(int n, int n2, int n3, Object object) throws IllegalArgumentException, IllegalStateException {
        if (object != null && object != this.sizeOwner) {
            if (this.sizeOwner == null) {
                this.sizeOwner = object;
            } else {
                throw new IllegalStateException("Zm\u011bna kroku a rozm\u011bru nen\u00ed dan\u00e9mu objektu povolena");
            }
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n4 = dimension.width - this.insets.left - this.insets.right;
        int n5 = dimension.height - this.insets.top - this.insets.bottom;
        int n6 = n * n2;
        int n7 = n * n3;
        if (n < 1 || n2 < 2 || n4 < n6 || n3 < 2 || n5 < n7) {
            throw new IllegalArgumentException("\nWrong size specification: \n  step  =" + n + " points,\n  width =" + n2 + " fields=" + n2 * n + " points,\n  height=" + n3 + " fields=" + n3 * n + " points,\n  screen=" + dimension.width + "\u00d7" + dimension.height + " points\n");
        }
        boolean bl = false;
        int n8 = this.window.getX();
        int n9 = this.window.getY();
        if (n8 + n6 > n4) {
            bl = true;
            n8 = n4 - n6;
        }
        if (n9 + n7 > n5) {
            bl = true;
            n8 = n5 - n7;
        }
        if (bl) {
            this.window.setLocation(n8, n9);
        }
    }

    private void setStepAndSizeInternal(int n, int n2, int n3) {
        this.width = n2 * n;
        this.height = n3 * n;
        this.window.setResizable(true);
        this.canvas.setPreferredSize(new Dimension(this.width, this.height));
        this.window.pack();
        this.window.setResizable(false);
        this.canvasImage = this.canvas.createImage(this.width, this.height);
        this.painter = new Painter((Graphics2D)this.canvasImage.getGraphics());
        this.painter.setBackground(this.backgroundColor);
        this.step = n;
        this.columns = n2;
        this.rows = n3;
        IO.Correction.windowSize(this.window);
        IO.Correction.windowLocation(this.window);
    }

    private void setVisibleInternal(boolean bl) {
        this.window.setVisible(bl);
        if (bl) {
            this.window.setLocation(this.position);
            this.window.setAlwaysOnTop(true);
            this.window.toFront();
            this.repaint();
            this.window.pack();
            this.window.setAlwaysOnTop(false);
        }
    }

    private void setVisible_IWait() {
        if (EventQueue.isDispatchThread()) {
            this.window.setVisible(true);
            this.window.pack();
            this.window.setAlwaysOnTop(true);
            this.window.setAlwaysOnTop(false);
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CanvasManager.this.window.setVisible(true);
                CanvasManager.this.repaint();
                CanvasManager.this.window.pack();
                CanvasManager.this.window.setAlwaysOnTop(true);
                CanvasManager.this.window.setAlwaysOnTop(false);
            }
        };
        try {
            EventQueue.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("\nV\u00fdjimka vyhozen\u00e1 b\u011bhem nastavov\u00e1n\u00ed kroku a rozm\u011bru", invocationTargetException);
        }
    }

    private static class Holder {
        volatile CanvasManager manager;

        private Holder() {
        }
    }
}

