/*
 * Decompiled with CFR 0.152.
 */
package ruplib.canvasmanager;

import java.util.ArrayList;
import java.util.List;
import ruplib.canvasmanager.ICMPaintable;
import ruplib.canvasmanager.ICMShape;
import ruplib.canvasmanager.Painter;
import ruplib.geom.AShape;
import ruplib.geom.Direction8;
import ruplib.geom.IChangeable;
import ruplib.geom.IDirectable;
import ruplib.geom.Position;
import ruplib.util.ICopyable;

public class Multishape
extends AShape
implements ICMShape,
IDirectable {
    public static final Direction8 DEFAULT_DIRECTION = Direction8.NORTH;
    private final List<Part> parts = new ArrayList<Part>();
    private boolean creationDone = false;
    private boolean copyable = true;
    private Direction8 direction;

    public Multishape() {
        this(null, new ICMShape[0]);
    }

    public Multishape(ICMShape iCMShape, ICMShape ... iCMShapeArray) {
        this(DEFAULT_DIRECTION, iCMShape, iCMShapeArray);
    }

    public Multishape(Direction8 direction8, ICMShape iCMShape, ICMShape ... iCMShapeArray) {
        super(0, 0, 1, 1);
        this.setDirectionInternal(direction8);
        if (iCMShape != null) {
            this.addShapes(iCMShape);
            this.addShapes(iCMShapeArray);
            this.creationDone = true;
        }
    }

    public boolean isCopyable() {
        return this.copyable;
    }

    @Override
    public Direction8 getDirection() {
        return this.direction;
    }

    @Override
    public void setDirection(Direction8 direction8) {
        this.verifyDone();
        if (this.getWidth() != this.getHeight()) {
            throw new IllegalStateException("\nNastavovat sm\u011br je mo\u017eno pouze pro \u010dtvercov\u00fd mnohotvar: " + String.valueOf(this));
        }
        if (direction8 == this.direction) {
            return;
        }
        Direction8 direction82 = this.direction;
        this.setDirectionInternal(direction8);
        this.turnTo(direction8, direction82);
    }

    public void setInitialDirection(Direction8 direction8) {
        try {
            this.verifyDone();
        }
        catch (IllegalStateException illegalStateException) {
            this.setDirectionInternal(direction8);
            return;
        }
        throw new IllegalStateException("\nPo\u010d\u00e1te\u010dn\u00ed sm\u011br mnohotvaru lze nastavit pouzep\u0159ed jeho dokon\u010den\u00edm");
    }

    @Override
    public void setPosition(int n, int n2) {
        this.verifyDone();
        int n3 = n - this.getX();
        int n4 = n2 - this.getY();
        CM.changeTogether(() -> {
            for (Part part : this.parts) {
                IChangeable iChangeable = part.changeable;
                Position position = iChangeable.getPosition();
                iChangeable.setPosition(position.x + n3, position.y + n4);
            }
            super.setPosition(n, n2);
        });
    }

    @Override
    public void setSize(int n, int n2) {
        this.verifyDone();
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("The dimensions may not be negativ: width=" + n + ", height=" + n2);
        }
        CM.changeTogether(() -> {
            for (Part part : this.parts) {
                part.afterResizing(n, n2);
            }
            super.setSize(Math.max(1, n), Math.max(1, n2));
        });
    }

    public int getNumberOfShapes() {
        return this.parts.size();
    }

    public int getNumberOfSimpleShapes() {
        int n = 0;
        for (Part part : this.parts) {
            if (part.changeable instanceof Multishape) {
                n += ((Multishape)part.changeable).getNumberOfSimpleShapes();
                continue;
            }
            ++n;
        }
        return n;
    }

    public final void addShapes(ICMShape ... iCMShapeArray) {
        for (ICMShape iCMShape : iCMShapeArray) {
            ICMShape iCMShape2 = iCMShape.copy();
            this.addTheShape(iCMShape2);
        }
        CM.repaint();
    }

    public final <T extends IChangeable & ICMPaintable> Multishape addTheShape(T t) {
        if (this.creationDone) {
            throw new IllegalStateException("\nAttempt to add a shape after finishing the creation of the mutlishape " + this.getName());
        }
        int n = t.getX();
        int n2 = t.getY();
        int n3 = t.getWidth();
        int n4 = t.getHeight();
        if (!(t instanceof ICopyable)) {
            this.copyable = false;
        }
        if (this.parts.isEmpty()) {
            super.setPosition(n, n2);
            super.setSize(n3, n4);
            this.parts.add(new Part(this, t, n, n2, n3, n4));
            return this;
        }
        int n5 = this.getX();
        int n6 = this.getY();
        int n7 = this.getWidth();
        int n8 = this.getHeight();
        int n9 = n5;
        int n10 = n6;
        int n11 = n7;
        int n12 = n8;
        boolean bl = false;
        if (n < n5) {
            n7 += n5 - n;
            n5 = n;
            super.setPosition(n5, n6);
            super.setSize(n7, n8);
            bl = true;
        }
        if (n2 < n6) {
            n8 += n6 - n2;
            n6 = n2;
            super.setPosition(n5, n6);
            super.setSize(n7, n8);
            bl = true;
        }
        if (n5 + n7 < n + n3) {
            n7 = n + n3 - n5;
            super.setSize(n7, n8);
            bl = true;
        }
        if (n6 + n8 < n2 + n4) {
            n8 = n2 + n4 - n6;
            super.setSize(n7, n8);
            bl = true;
        }
        if (bl) {
            for (Part part : this.parts) {
                part.afterAddition(n9, n10, n11, n12);
            }
        }
        this.parts.add(new Part(this, t));
        return this;
    }

    @Override
    public Multishape copy() {
        if (!this.copyable) {
            throw new IllegalStateException("\nDan\u00fd mnohotvar nen\u00ed kop\u00edrovateln\u00fd");
        }
        ICMShape[] iCMShapeArray = new ICMShape[this.parts.size() - 1];
        ICMShape iCMShape = (ICMShape)this.parts.get((int)0).changeable;
        for (int i = 0; i < iCMShapeArray.length; ++i) {
            Part part = this.parts.get(i + 1);
            iCMShapeArray[i] = (ICMShape)part.changeable;
        }
        Multishape multishape = new Multishape(iCMShape, iCMShapeArray);
        return multishape;
    }

    public void creationDone() {
        if (this.parts.size() < 1) {
            throw new IllegalStateException("\nThe multishape has to have at least one part");
        }
        this.creationDone = true;
    }

    @Override
    public void paint(Painter painter) {
        CM.changeTogether(() -> {
            for (Part part : this.parts) {
                part.paintable.paint(painter);
            }
        });
    }

    @Override
    protected String forToString() {
        return super.forToString() + ", sm\u011br=" + String.valueOf((Object)this.getDirection());
    }

    private void setDirectionInternal(Direction8 direction8) {
        if (!direction8.isCardinal()) {
            throw new IllegalArgumentException("\nMnohotvar lze nato\u010dit pouze do jednoho ze \u010dty\u0159 hlavn\u00edch sm\u011br\u016f, po\u017eadov\u00e1no: " + String.valueOf((Object)direction8));
        }
        this.direction = direction8;
    }

    private void turnTo(Direction8 direction8, Direction8 direction82) {
        if (direction8 == Direction8.NOWHERE) {
            return;
        }
        Direction8[] direction8Array = null;
        int n = this.getWidth();
        int n2 = direction82.ordinalDistanceTo(direction8);
        for (Part part : this.parts) {
            double d;
            double d2;
            double d3;
            if (part.changeable instanceof IDirectable) {
                if (direction8Array == null) {
                    direction8Array = Direction8.values();
                }
                Direction8 direction83 = ((IDirectable)((Object)part.changeable)).getDirection();
                Direction8 direction84 = direction8Array[direction83.ordinal() + n2];
                ((IDirectable)((Object)part.changeable)).setDirection(direction84);
            }
            double d4 = switch (n2) {
                case -6, 2 -> {
                    d3 = part.dy;
                    d2 = 1.0 - part.dx - part.dw;
                    d = part.dh;
                    yield part.dw;
                }
                case -4, 4 -> {
                    d3 = 1.0 - part.dx - part.dw;
                    d2 = 1.0 - part.dy - part.dh;
                    d = part.dw;
                    yield part.dh;
                }
                case -2, 6 -> {
                    d3 = 1.0 - part.dy - part.dh;
                    d2 = part.dx;
                    d = part.dh;
                    yield part.dw;
                }
                default -> throw new RuntimeException("\nNen\u00ed mo\u017en\u00e9 oto\u010dit oblast ze sm\u011bru " + String.valueOf((Object)direction82) + " do sm\u011bru " + String.valueOf(this));
            };
            part.dx = d3;
            part.dy = d2;
            part.dw = d;
            part.dh = d4;
            part.afterResizing(n, n);
        }
    }

    private void verifyDone() {
        if (this.creationDone) {
            return;
        }
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string = stackTraceElementArray[1].getMethodName();
        throw new IllegalStateException("\nNedokon\u010den\u00fd tvar nem\u016f\u017ee volat metodu: " + string);
    }

    private final class Part {
        IChangeable changeable;
        ICMPaintable paintable;
        double dx;
        double dy;
        double dw;
        double dh;
        final /* synthetic */ Multishape this$0;

        <T extends IChangeable & ICMPaintable> Part(T t) {
            this(var1_1, t, var1_1.getX(), var1_1.getY(), var1_1.getWidth(), var1_1.getHeight());
        }

        /*
         * WARNING - Possible parameter corruption
         */
        <T extends IChangeable & ICMPaintable> Part(T t, int n2, int n3, int n4, int n5) {
            this.this$0 = (Multishape)n;
            this.changeable = t;
            this.paintable = t;
            int n6 = t.getX();
            int n7 = t.getY();
            int n8 = t.getWidth();
            int n9 = t.getHeight();
            double d = n4;
            double d2 = n5;
            this.dx = (double)(n6 - n2) / d;
            this.dy = (double)(n7 - n3) / d2;
            this.dw = (double)n8 / d;
            this.dh = (double)n9 / d2;
        }

        void afterAddition(int n, int n2, int n3, int n4) {
            this.dx = ((double)(n - this.this$0.getX()) + this.dx * (double)n3) / (double)this.this$0.getWidth();
            this.dy = ((double)(n2 - this.this$0.getY()) + this.dy * (double)n4) / (double)this.this$0.getHeight();
            this.dw = this.dw * (double)n3 / (double)this.this$0.getWidth();
            this.dh = this.dh * (double)n4 / (double)this.this$0.getHeight();
        }

        void afterResizing(int n, int n2) {
            this.changeable.setPosition((int)Math.round((double)this.this$0.getX() + this.dx * (double)n), (int)Math.round((double)this.this$0.getY() + this.dy * (double)n2));
            this.changeable.setSize((int)Math.round(this.dw * (double)n), (int)Math.round(this.dh * (double)n2));
        }

        public String toString() {
            return "Part[shape=" + String.valueOf(this.changeable) + ", dx=" + this.dx + ", dy=" + this.dy + ", dw=" + this.dw + ", dh=" + this.dh + "]";
        }
    }
}

