/*
 * Decompiled with CFR 0.152.
 */
package ruplib.canvasmanager;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.net.MalformedURLException;
import java.net.URL;
import ruplib.canvasmanager.ICMShape;
import ruplib.canvasmanager.Painter;
import ruplib.geom.Direction8;
import ruplib.geom.IDirectable;
import ruplib.util.ICopyable;

public class Picture
implements ICMShape,
IDirectable,
ICopyable {
    private static int countCreated = 0;
    protected final int ID = ++countCreated;
    private final Image image;
    private final int origWidth;
    private final int origHeight;
    AffineTransform aft;
    private String name = "Obr\u00e1zek_" + this.ID;
    private Direction8 initialDirection;
    private Direction8 direction = this.initialDirection = Direction8.NORTH;
    private boolean directionSet;
    private int xPos;
    private int yPos;
    protected int width;
    protected int height;

    public Picture(int n, int n2, String string) {
        this(n, n2, string, null);
    }

    public Picture(int n, int n2, URL uRL) {
        this(n, n2, null, Toolkit.getDefaultToolkit().getImage(uRL));
    }

    public Picture(int n, int n2, Image image) {
        this(n, n2, null, image);
    }

    private Picture(int n, int n2, String string, Image image) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("\nParametry nemaj\u00ed povolen\u00e9 hodnoty: x=" + n + ", y=" + n2);
        }
        this.xPos = n;
        this.yPos = n2;
        if (image != null) {
            this.image = image;
        } else {
            URL uRL;
            if (string.charAt(0) == '*') {
                if (string.charAt(1) == '*') {
                    String string2 = string.substring(3);
                    uRL = this.getClass().getClassLoader().getResource(string2);
                } else {
                    Class<?> clazz;
                    Throwable throwable = new Throwable();
                    StackTraceElement stackTraceElement = throwable.getStackTrace()[1];
                    String string3 = stackTraceElement.getClassName();
                    try {
                        clazz = Class.forName(string3);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new RuntimeException("\nN\u011bco se pod\u011blalo - nena\u0161el existuj\u00edc\u00ed t\u0159\u00eddu " + string3, classNotFoundException);
                    }
                    String string4 = string.substring(2);
                    uRL = clazz.getResource(string4);
                }
            } else {
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException("\nNepoda\u0159ilo se na\u010d\u00edst obr\u00e1zek v souboru " + string, malformedURLException);
                }
            }
            this.image = Toolkit.getDefaultToolkit().getImage(uRL);
        }
        this.origWidth = this.image.getWidth(Painter.IMG_OBSERVER);
        this.origHeight = this.image.getHeight(Painter.IMG_OBSERVER);
        this.width = this.origWidth;
        this.height = this.origHeight;
    }

    @Override
    public Direction8 getDirection() {
        this.directionSet = true;
        return this.direction;
    }

    @Override
    public void setDirection(Direction8 direction8) {
        this.directionSet = true;
        if (this.direction == direction8) {
            return;
        }
        this.verifyRequest(direction8);
        this.setDirSize(direction8, this.getWidth(), this.getHeight());
        CM.repaint();
    }

    public synchronized Picture setInitialDirection(Direction8 direction8) {
        if (this.directionSet) {
            throw new IllegalStateException("\nPo\u010d\u00e1te\u010dn\u00ed sm\u011br u\u017e byl nastaven nebo pou\u017eit");
        }
        this.verifyRequest(direction8);
        this.direction = this.initialDirection = direction8;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public int getX() {
        return this.xPos;
    }

    @Override
    public int getY() {
        return this.yPos;
    }

    @Override
    public void setPosition(int n, int n2) {
        if (this.aft != null) {
            this.aft = new AffineTransform(this.aft.getScaleX(), this.aft.getShearY(), this.aft.getShearX(), this.aft.getScaleY(), (double)n, (double)n2);
        }
        this.xPos = n;
        this.yPos = n2;
        CM.repaint();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setSize(int n, int n2) {
        this.setDirSize(this.getDirection(), n, n2);
        this.width = n;
        this.height = n2;
        CM.repaint();
    }

    @Override
    public Picture copy() {
        Picture picture = new Picture(this.getX(), this.getY(), this.image);
        picture.setInitialDirection(this.initialDirection);
        picture.setSize(this.getWidth(), this.getHeight());
        picture.setDirection(this.direction);
        return picture;
    }

    @Override
    public void paint(Painter painter) {
        if (this.aft == null) {
            painter.drawPicture(this.xPos, this.yPos, this.image, null);
        } else {
            painter.drawPicture(0, 0, this.image, this.aft);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "#" + (100 + this.hashCode() % 900);
    }

    public void setDirSize(Direction8 direction8, int n, int n2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        this.direction = direction8;
        int n3 = direction8.ordinalDistanceTo(this.initialDirection);
        switch (n3) {
            case 0: {
                if (n == this.origWidth && n2 == this.origHeight) {
                    this.aft = null;
                    return;
                }
                d6 = (double)n / (double)this.origWidth;
                d5 = 0.0;
                d4 = this.getX();
                d3 = 0.0;
                d2 = (double)n2 / (double)this.origHeight;
                d = this.getY();
                break;
            }
            case -6: 
            case 2: {
                d6 = 0.0;
                d5 = -((double)n2 / (double)this.origHeight);
                d4 = this.getX() + n2;
                d3 = (double)n / (double)this.origWidth;
                d2 = 0.0;
                d = this.getY();
                break;
            }
            case -4: 
            case 4: {
                d6 = -((double)n / (double)this.origWidth);
                d5 = 0.0;
                d4 = this.getX() + n;
                d3 = 0.0;
                d2 = -((double)n2 / (double)this.origHeight);
                d = this.getY() + n2;
                break;
            }
            case -2: 
            case 6: {
                d6 = 0.0;
                d5 = (double)n2 / (double)this.origHeight;
                d4 = this.getX();
                d3 = -((double)n / (double)this.origWidth);
                d2 = 0.0;
                d = this.getY() + n;
                break;
            }
            default: {
                throw new RuntimeException("\nNepovolen\u00e9 oto\u010den\u00ed");
            }
        }
        this.aft = new AffineTransform(d6, d3, d5, d2, d4, d);
    }

    private void verifyRequest(Direction8 direction8) {
        if (!direction8.isCardinal()) {
            throw new IllegalArgumentException("\nObr\u00e1zek lze nato\u010dit pouze do jednoho ze \u010dty\u0159 hlavn\u00edch sm\u011br\u016f, po\u017eadov\u00e1no: " + String.valueOf((Object)direction8));
        }
    }
}

