/*
 * Decompiled with CFR 0.152.
 */
package ruplib.dbg;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;
import ruplib.util.IO;

public class IndentingPrintStream
extends PrintStream {
    protected static final String DEFAULT_ENCODING = "windows-1250";
    private static boolean toASCII = false;
    private static String defaultIndentIncrement = "|  ";
    private static volatile PrintStream originalSystemOut;
    private static volatile IndentingPrintStream mySystemOut;
    private static boolean defaultThreadSensitivity;
    private final Charset charset;
    private final boolean threadSensitive;
    private final ThreadLocalIndent indent;
    private String indentIncrement = defaultIndentIncrement;
    private Thread lastThread;

    public static String getDefaultIndentIncrement() {
        return defaultIndentIncrement;
    }

    public static void setDefaultIndentIncrement(String string) {
        defaultIndentIncrement = string;
    }

    public static void setThreadSensitive(boolean bl) {
        defaultThreadSensitivity = bl;
    }

    public static void setSystemOut() {
        IndentingPrintStream.setSystemOut(DEFAULT_ENCODING);
    }

    public static synchronized void setSystemOut(String string) {
        IndentingPrintStream.setSystemOut(System.out, string);
    }

    public static synchronized void setSystemOut(OutputStream outputStream) {
        IndentingPrintStream.setSystemOut(outputStream, DEFAULT_ENCODING);
    }

    public static synchronized void setSystemOut(OutputStream outputStream, String string) {
        if (originalSystemOut == null) {
            originalSystemOut = System.out;
            if (outputStream instanceof IndentingPrintStream) {
                IndentingPrintStream indentingPrintStream = (IndentingPrintStream)outputStream;
                Charset charset = string == null ? Charset.defaultCharset() : Charset.forName(string);
                if (!charset.equals(indentingPrintStream.charset)) {
                    throw new IllegalArgumentException("\nZnakov\u00e1 sada nastavovan\u00e9ho proudu neodpov\u00edd\u00e1 po\u017eadovan\u00e9: " + string + " # " + String.valueOf(charset));
                }
                mySystemOut = indentingPrintStream;
            } else {
                mySystemOut = IndentingPrintStream.indentifyPrintStream(outputStream, string);
            }
            System.setOut(mySystemOut);
        } else if (mySystemOut != outputStream) {
            throw new IllegalArgumentException("\nStandardn\u00ed syst\u00e9mov\u00fd v\u00fdstup je ji\u017e nastaven.\nPokud jej chete zm\u011bnit, mus\u00edte nejprve p\u016fvodn\u00ed nastaven\u00ed zru\u0161it");
        }
    }

    public static void setToASCII(boolean bl) {
        toASCII = bl;
    }

    public static synchronized boolean returnSystemOut() {
        if (originalSystemOut == null) {
            return false;
        }
        if (System.out != mySystemOut) {
            throw new IllegalStateException("\nNelze vr\u00e1tit p\u016fvodn\u00ed nastven\u00ed objektu System.out, proto\u017ee je n\u011bkdo mezit\u00edm zm\u011bnil");
        }
        System.setOut(originalSystemOut);
        originalSystemOut = null;
        mySystemOut = null;
        return true;
    }

    public static IndentingPrintStream indentifyPrintStream(OutputStream outputStream) {
        return IndentingPrintStream.indentifyPrintStream(System.out, "UTF-8");
    }

    public static IndentingPrintStream indentifyPrintStream(OutputStream outputStream, String string) {
        IndentingPrintStream indentingPrintStream;
        try {
            indentingPrintStream = new IndentingPrintStream(outputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("\nZadan\u00e1 k\u00f3dov\u00e1 str\u00e1nka nen\u00ed podporov\u00e1na: " + string, unsupportedEncodingException);
        }
        return indentingPrintStream;
    }

    protected IndentingPrintStream(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super((OutputStream)System.out, true, string);
        this.charset = Charset.forName(string);
        this.threadSensitive = defaultThreadSensitivity;
        this.indent = new ThreadLocalIndent();
        this.out = new IndentingOutputStream(outputStream);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setIndentIncrement(String string) {
        this.indentIncrement = string;
    }

    public boolean isSystemOut() {
        return this == mySystemOut;
    }

    public IndentingPrintStream indent() {
        this.indent.set((String)this.indent.get() + this.indentIncrement);
        this.println();
        return this;
    }

    public IndentingPrintStream outdent() {
        if (((String)this.indent.get()).length() < this.indentIncrement.length()) {
            throw new RuntimeException("\nByla p\u0159ijata p\u0159espo\u010detn\u00e1 \u017e\u00e1dost o p\u0159isazen\u00ed");
        }
        this.indent.set(((String)this.indent.get()).substring(0, ((String)this.indent.get()).length() - this.indentIncrement.length()));
        this.println();
        return this;
    }

    @Override
    public IndentingPrintStream append(CharSequence charSequence) {
        super.append(charSequence);
        return this;
    }

    @Override
    public IndentingPrintStream append(CharSequence charSequence, int n, int n2) {
        if (toASCII) {
            CharSequence charSequence2 = charSequence == null ? "null" : charSequence;
            String string = charSequence2.subSequence(n, n2).toString();
            string = IO.toASCII(string);
            super.print(string);
        } else {
            super.append(charSequence, n, n2);
        }
        return this;
    }

    @Override
    public IndentingPrintStream append(char c) {
        if (toASCII) {
            String string = IO.toASCII(Character.toString(c));
            super.print(string);
        } else {
            super.append(c);
        }
        return this;
    }

    @Override
    public IndentingPrintStream format(String string, Object ... objectArray) {
        if (toASCII) {
            super.format(string, new Object[]{IndentingPrintStream.removeAccents(objectArray)});
        } else {
            super.format(string, objectArray);
        }
        return this;
    }

    @Override
    public IndentingPrintStream format(Locale locale, String string, Object ... objectArray) {
        if (toASCII) {
            super.format(locale, string, new Object[]{IndentingPrintStream.removeAccents(objectArray)});
        } else {
            super.format(locale, string, objectArray);
        }
        return this;
    }

    @Override
    public IndentingPrintStream printf(String string, Object ... objectArray) {
        super.printf(string, objectArray);
        return this;
    }

    @Override
    public IndentingPrintStream printf(Locale locale, String string, Object ... objectArray) {
        super.format(locale, string, objectArray);
        return this;
    }

    @Override
    public void print(String string) {
        if (toASCII) {
            string = IO.toASCII(string);
        }
        super.print(string);
    }

    @Override
    public void write(int n) {
        if (toASCII) {
            String string = IO.toASCII(String.valueOf(Character.toChars(n)));
            super.print(string);
        }
        super.write(n);
    }

    private static String[] removeAccents(Object[] objectArray) {
        int n = objectArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string = objectArray[i].toString();
            stringArray[i] = string = IO.toASCII(string);
        }
        return stringArray;
    }

    private class ThreadLocalIndent
    extends ThreadLocal<String> {
        private ThreadLocalIndent() {
        }

        @Override
        public String initialValue() {
            if (IndentingPrintStream.this.threadSensitive) {
                return Thread.currentThread().toString() + ": ";
            }
            return "";
        }
    }

    private class IndentingOutputStream
    extends FilterOutputStream {
        IndentingOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public synchronized void write(int n) throws IOException {
            Thread thread = Thread.currentThread();
            if (!thread.equals(IndentingPrintStream.this.lastThread)) {
                IndentingPrintStream.this.lastThread = thread;
                this.write(10);
            }
            super.write(n);
            if (n == 10) {
                super.write(((String)IndentingPrintStream.this.indent.get()).getBytes());
            }
        }

        @Override
        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            super.write(byArray, n, n2);
        }
    }
}

