/*
 * Decompiled with CFR 0.152.
 */
package ruplib.util;

import java.util.function.Supplier;
import java.util.stream.Stream;

@FunctionalInterface
public interface IStreamable<T> {
    public static <T> IStreamable<T> get(Supplier<Stream<T>> supplier) {
        return new Impl(supplier);
    }

    public Stream<T> stream();

    public static class Impl<E>
    implements IStreamable<E> {
        private final Supplier<Stream<E>> streamSupplier;

        public Impl(Supplier<Stream<E>> supplier) {
            this.streamSupplier = supplier;
        }

        @Override
        public Stream<E> stream() {
            return this.streamSupplier.get();
        }
    }
}

