/* M:/72_INP/17__Subclassing.jsh
Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó

Příkazy a úryvky zadávané ve výpisech v kapitole:
17  Úvod do dědění implementace
/*************************************************************************/


/*
** Výpis 17.0: Inicializace
********************************************************************/
/set start Start_17.jsh
/reset
/********************************************************************


/*
** Výpis 17.1:	Definice třídy Square a prověření její funkčnosti
********************************************************************/
class Square extends Rectangle {}
void inform(Object o, String message)
{
    String text = message + "\n   " + o;
    System.out.println(text);
    IO.inform(text);
}
void testSquare(Square sq)
{
                                 inform(sq,"Testovaný objekt");
    sq.moveRight(100);           inform(sq,"Po posunu o 100 bodů vpravo");
    sq.setSize(200);             inform(sq,"Po změně rozměru na 200");
    sq.setPosition(50, 50);      inform(sq,"Po posunu na pozici [50;50]");
    sq.setColor(NamedColor.GOLD);inform(sq,"Po nastavení zlaté barvy");
}
testSquare(new Square());
/********************************************************************


/*
** Výpis 17.2:	Definice třídy Square s upravenou verzí konstruktoru
********************************************************************/
class Square extends Rectangle
{
    Square()
    {
        super();
        setSize(Canvas.getStep());
    }
}
/-2
/********************************************************************


/*
** Výpis 17.3:	Definice třídy Square se čtyřmi konstruktory
********************************************************************/
class Square extends Rectangle
{
    Square()
    {
        this(0, 0);
    }

    Square(int x, int y)
    {
        this(x, y, Canvas.getStep());
    }

    Square(int x, int y, int size)
    {
        super(x, y, size, size);
//    //Tělo by bylo možno stejně dobře definovat příkazem
//    this(x, y, size, DEFAULT_COLOR);
    }

    Square(int x, int y, int size, NamedColor color)
    {
        super(x, y, size, size, color);
    }
}
{ testSquare(new Square());
  testSquare(new Square(50, 100));
  testSquare(new Square(50,  50, 150));
  testSquare(new Square(25,  25,  25, NamedColor.GRAY));
}
/********************************************************************


/*
** Výpis 17.4:	Definice třídy Granddaughter17
********************************************************************/
/* Kód je uložen v souboru:
M:/72_Java/b72_j21ref/c17_inheritance/Granddaughter17.java
*/
/********************************************************************


/*
** Výpis 17.5:	Definice metody constructorReport(Object,Class)
 * 				ve třídě Reports17
********************************************************************/
/* Kód je uložen v souboru:
M:/72_Java/b72_j21ref/c17_inheritance/Reports17.java
*/
/********************************************************************


/*
** Výpis 17.6:	Vytváření instancí tříd v dědické hierarchii
********************************************************************/
/open 17a_Reports17.jsh
/open 17b_Mother17.jsh
/open 17c_Daughter17.jsh
/open 17d_Granddaughter17.jsh
{
    new Granddaughter17();
    new Daughter17();
    new Mother17();
}
/********************************************************************


/*
** Výpis 17.7:	Definice zalepených typů a jejich potomků definovaných uvnitř
********************************************************************/
sealed class Řešení {
    final class Diskrétní extends Řešení {}
    final class Spojité   extends Řešení {}
    class PomocnáTřída {}
}
final class Chybné  extends Řešení {}
sealed interface IŘešení {
    final class Diskrétní implements IŘešení {}
    final class Spojité   implements IŘešení {}
    class PomocnáTřída {}
}
/********************************************************************


/*
** Výpis 17.8:	Definice zalepených typů a jejich potomků definovaných samostatně
********************************************************************/
abstract sealed class Člověk permits Muž, Žena {}
final class Muž  extends Člověk {}
final class Žena extends Člověk {}
final class Dítě extends Člověk {}
/********************************************************************


/*
** Výpis 17.9:	Demo využívající všech tří povolených modifikátorů
********************************************************************/
class DEMO
{
    sealed class Shape
         permits Circle, Rectangle, WeirdShape { /*...*/ }

    final class Circle extends Shape { /*...*/ }

    sealed class Rectangle extends Shape
         permits TransparentRectangle, FilledRectangle { /*...*/ }

    final class TransparentRectangle extends Rectangle { /*...*/ }
    final class FilledRectangle      extends Rectangle { /*...*/ }

    non-sealed class WeirdShape extends Shape { /*...*/ }

    class Star     extends WeirdShape { /*...*/ }
    class Donut    extends WeirdShape { /*...*/ }
    class Crescent extends WeirdShape { /*...*/ }
}
/********************************************************************


/*
** Výpis 17.10:	Stejné zadání, ale s odebranou vnější třídou
********************************************************************/
sealed class Shape
     permits Circle, Rectangle, WeirdShape { /*...*/ }
final class Circle extends Shape { /*...*/ }
sealed class Rectangle extends Shape
     permits TransparentRectangle, FilledRectangle { /*...*/ }
final class TransparentRectangle extends Rectangle { /*...*/ }
final class FilledRectangle      extends Rectangle { /*...*/ }
non-sealed class WeirdShape extends Shape { /*...*/ }
class Star     extends WeirdShape { /*...*/ }
class Donut    extends WeirdShape { /*...*/ }
class Crescent extends WeirdShape { /*...*/ }
/********************************************************************


/*
** Výpis	17.0: Popis
********************************************************************/
                                                               //SYNC
/* Kód je uložen v souboru:
M:/72_Java/b72_j21ref/c17_inheritance/XXX.java
*/
