/* M:/72_INP/27__Patterns.jsh
Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó

Příkazy a úryvky zadávané ve výpisech v kapitole:
27  Další použití rozpoznávání vzorů
/*************************************************************************/


/*
** Výpis 27.0:	Inicializace
********************************************************************/
/********************************************************************


/*
** Výpis 27.1:	Definice proměnných s hodnotami atributů záznamu
********************************************************************/
record Point(int x, int y) {}
void iofJ16(Object obj) {      //Od verze 16
    if (obj instanceof Point p) {
        int x = p.x();
        int y = p.y();
        System.out.println(x+y);
    }
}
void iofJ21(Object obj) {     //Od verze 21
    if (obj instanceof Point(int x, int y)) {
        System.out.println(x+y);
    }
}
/********************************************************************


/*
** Výpis 27.2:	Získání hodnot z hlubin testovaného záznamu
********************************************************************/
enum Color { RED, GREEN, BLUE }
record ColoredPoint(Point p, Color c) {}
record Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}
void inside(Rectangle r) {
    var line = "\n" + "-".repeat(40);
    if (r instanceof Rectangle(ColoredPoint ul, ColoredPoint lr)) {
         System.out.println("UpperLeftColor  = " + ul.c()
                        + "\nLowerRightPoint = " + lr.p() + line);
    }
    if (r instanceof Rectangle(ColoredPoint(Point ulp, Color ulc),
                               ColoredPoint lr)) {
        System.out.println(STR."""
            UpperLeftPoint         = \{ulp}
            UpperLeftColor         = \{ulc}
            LowerRightColoredPoint = \{lr}\{line} """);
    }
    if (r instanceof
          Rectangle(ColoredPoint(Point(var x1, var y1), var c1),
                    ColoredPoint(Point(var x2, var y2), var c2))) {
        System.out.println(STR."""
            UpperLeft  = [Point(x1=\{x1}, y1=\{y1}), Color(\{c1})]
            LowerRight = [Point(x2=\{x2}, y2=\{y2}), Color(\{c2})]\
            \{line}""");
    }
    System.out.println("r = " + r);
}
inside(new Rectangle(new ColoredPoint(new Point(1,10), Color.RED),
                     new ColoredPoint(new Point(2,20), Color.BLUE)));
/********************************************************************


/*
** Výpis 27.3:	Rozpoznávání vzorů v generickém záznamu
********************************************************************/
interface IPair<X,Y> {}
record MyPair<A,B>(A a, B b) implements IPair<A,B> {
    String tAB() { return "<" + a.getClass().getSimpleName() + ", "
                              + b.getClass().getSimpleName() + ">"; }
}
void inference(IPair<String, Integer> p) {
    if (p instanceof MyPair pair) {
        System.out.println(STR."REC:  a=\"\{pair.a()}\", b=\{pair.b()} - "
                                    + pair.tAB());
    }
    if (p instanceof MyPair(var x, var y)) {
        System.out.println(STR."ARGS: a=\"\{x}\", b=\{y} - "
                                    + ((MyPair)p).tAB());
    }
}
inference(new MyPair<>("3", 4));
public <X,Y> void inferr(MyPair<X, Y> p) {
    if (p instanceof MyPair<String, Integer> pair) {}
}
record Box<T>(T t) {}
void embedded(Box<Box<String>> bbs) {
    if (bbs instanceof Box<Box<String>>(Box(var s))) {
        System.out.println("Úplná deklarace:   String=" + s);
    }
    if (bbs instanceof Box(Box(var s))) {
        System.out.println("Stručná deklarace: String=" + s);
    }
}
embedded(new Box<>(new Box<>("BAF")));
/********************************************************************


/*
** Výpis 27.4:	Rozpoznávání vzorů v příkazu switch
********************************************************************/
void sw26(Object obj) {
    String result = switch (obj) {
        case Integer i -> String.format("int %d", i);
        case Long l    -> String.format("long %d", l);
        case Double d  -> String.format("double %f", d);
        case String s  -> String.format("String %s", s);
        default        -> "Jiný " + obj.toString();
    };
    System.out.println(obj.getClass().getSimpleName()
                     + " - " + result);
}
{ sw26(1); sw26(3.14); sw26("STRING"); sw26(new Date()); }
/********************************************************************


/*
** Výpis 27.5:	Použití hodnoty null a omezení when
********************************************************************/
void nullWhen(String response) {
    switch (response) {
        case null -> { }
        case "a", "A" -> {
            System.out.println("Přijato");
        }
        case "n", "N" -> {
            System.out.println("Nebrat");
        }
        case String s
        when s.equalsIgnoreCase("ANO") -> {
            System.out.println("Přijato");
        }
        case String s
        when s.equalsIgnoreCase("NE") -> {
            System.out.println("Nebrat");
        }
        case String s -> {
            System.out.println(s + " - Špatná odpověď!");
        }
    }
}
{ nullWhen("n"); nullWhen("ano"); nullWhen("nevím"); }
/********************************************************************


/*
** Výpis 27.6:	Detekce konstant výčtových typů
********************************************************************/
sealed interface ICardClass permits Suit, Tarot {}
public enum Suit  implements ICardClass { CLUBS, DIAMONDS, HEARTS, SPADES }
final class Tarot implements ICardClass {}

void cards1(ICardClass c) {
    switch (c) {
        case Suit s when s == Suit.CLUBS -> {
            System.out.println("Kříže");
        }
        case Suit s when s == Suit.DIAMONDS -> {
            System.out.println("Káry");
        }
        case Suit s when s == Suit.HEARTS -> {
            System.out.println("Srdce");
        }
        case Suit s -> {
            System.out.println("Listy");
        }
        case Tarot t -> {
            System.out.println("Taroky");
        }
    }
}
void cards2(ICardClass c) {
    switch (c) {
        case Suit.CLUBS    ->  System.out.println("Kříže" );
        case Suit.DIAMONDS ->  System.out.println("Káry"  );
        case Suit.HEARTS   ->  System.out.println("Srdce" );
        case Suit.SPADES   ->  System.out.println("Listy" );
        case Tarot t       ->  System.out.println("Taroky");
    }
}
/********************************************************************


/*
** Výpis 27.7:	Definice metod, v nichž překladač odhalí nepokrytí všech možností
********************************************************************/
void matchI(Integer n) {
    switch (n)  {
        case Integer i when i > 0 ->  System.out.println("kladný");
        case Integer i when i < 0 ->  System.out.println("záporný");
//        case Integer i            ->  System.out.println("nulový");
    }
}

void matchN(Number n) {
    switch (n)  {
        case Integer i when i > 0 ->  System.out.println("kladný");
        case Integer i when i < 0 ->  System.out.println("záporný");
        case Integer i            ->  System.out.println("nulový");
//        default                   ->  System.out.println(n.getClass());
    }
}
/********************************************************************


/*
** Výpis 27.8:	Demonstrace rozpoznávání typových parametrů
********************************************************************/
/set feedback concise
class A {}
class B extends A {}
sealed interface I permits C, D {}
final class C implements I {}
final class D implements I {}
record Pair<T>(T x, T y) {}

Pair<A> p1 = new Pair<>(new A(), new B());
Pair<I> p2 = new Pair<>(new C(), new D());

switch (p1) {
    case Pair<A>(A a, B b) -> System.out.println("Verze A-B");
    case Pair<A>(B b, A a) -> System.out.println("Verze B-A");
}

switch (p2) {
    case Pair<I>(I i, C c) -> System.out.println("Verze I-C");
    case Pair<I>(I i, D d) -> System.out.println("Verze I-D");
}

switch (p2) {
    case Pair<I>(C x, I y) -> System.out.println("Verze C-I");
    case Pair<I>(D x, C y) -> System.out.println("Verze D-C");
    case Pair<I>(D x, D y) -> System.out.println("Verze D-D");
}
switch (p2) {
    case Pair<I>(C x, D y) -> System.out.println("Verze C-D");
    case Pair<I>(D x, C y) -> System.out.println("Verze D-C");
    case Pair<I>(I x, C y) -> System.out.println("Verze I-C");
}
/********************************************************************


/*
** Výpis X.0:	Popis
********************************************************************/
                                                               //SYNC
/* Kód je uložen v souboru:
M:/72_Java/b72_j21ref/c27_patterns/XXX.java
*/
