/* M:/72_INP/Start_06.jsh
Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó

Inicializační skript pro kapitolu:
06  Ostatní operátory
**************************************************************************/

import java.util.*;
import java.util.regex.*;


/**************************************************************************
 * Klon metody ze standardní knihovny.
 *
 * @param obj Objekt, jehož textová podoba se má vytisknout
 */
void println(Object obj)
{
    System.out.println(obj);
}


/**************************************************************************
 * Klon metody ze standardní knihovny.
 *
 * @param obj Objekt, jehož textová podoba se má vytisknout
 */
void printf(String format, Object... args)
{
    System.out.printf(format, args);
}


/**************************************************************************
 * Vloží do zadaného textu znaky podtržení tak, aby jej rozdělily
 * na čtveřice znaků, přičemž levá skupina nemusí mít plný počet znaků.
 *
 * @param text Text určený k doplnění podtržítek
 * @return Výsledný text
 */
String add_(String text)
{
    Pattern p = Pattern.compile(
         "([0-9A-Fa-f])(?=([0-9A-Fa-f]{4})+(?![0-9A-Fa-f]))");
    Matcher m = p.matcher(text);
    StringBuffer sb = new StringBuffer();
    while (m.find()) {
        m.appendReplacement(sb, "$1_");
    }
    m.appendTail(sb);
    return sb.toString();
}


/**************************************************************************
 * Doplní zadaný text představující číslo o úvodní nuly tak,
 * aby obsahoval zadaný počet znaků, a upravený text pak
 * nechá rozdělit znaky podtržení na čtveřice.
 *
 * @param number    Stringová reprezentace čísla
 * @param positions Požadovaný počet pozic
 * @return Výsledná textová podoba čísla
 */
String x2len(String number, int positions)
{
    //    private static final
    String ZEROES =
        "0000000000000000000000000000000000000000000000000000000000000000";

    int ZEROES_LENGTH = ZEROES.length();
    int len = number.length();
    if (len > positions) {
        number = number.substring(len - positions);
    }
    else if (len < positions) {
        String added = ZEROES.substring(ZEROES_LENGTH - positions + len);
        number = added + number;
    }
    return add_(number);
}


/**************************************************************************
 * Převede zadané číslo do hexadecimálního tvaru se zadaným počtem cifer,
 * přičemž jednotlivé čtveřice číslic budou odděleny znaky podtržení.
 *
 * @param number    Převáděné číslo
 * @param positions Požadovaný počet zobrazovaných cifer
 * @return Požadovaný hexadecimální tvar čísla
 */
String x2hex(long number, int positions)
{
    String  s1 = Long.toHexString(number);
    return "0x" + x2len(s1, positions);
}


/**************************************************************************
 * Převede zadané číslo do binárního tvaru se zadaným počtem cifer,
 * přičemž jednotlivé čtveřice číslic budou odděleny znaky podtržení.
 *
 * @param number    Převáděné číslo
 * @param positions Požadovaný počet zobrazovaných cifer
 * @return Požadovaný hexadecimální tvar čísla
 */
String x2bin(long number, int positions)
{
    String  s1 = Long.toBinaryString(number);
    return "0b" + x2len(s1, positions);
}


/**************************************************************************
 * Převede zadané číslo do úplného binárního tvaru s 64 číslicemi,
 * přičemž jednotlivé čtveřice čísel budou odděleny znaky podtržení.
 *
 * @param number    Převáděné číslo
 * @return Požadovaný binírní tvar čísla
 */
String toLongBin(long number)
{
    return x2bin(number, 64);
}



/**************************************************************************
 * Převede zadané číslo do úplného binárního tvaru s 32 číslicemi,
 * přičemž jednotlivé čtveřice čísel budou odděleny znaky podtržení.
 *
 * @param number    Převáděné číslo
 * @return Požadovaný binírní tvar čísla
 */
String toIntBin(long number)
{
    return x2bin(number, 32);
}


/**************************************************************************
 * Převede zadané číslo do úplného binárního tvaru s 16 číslicemi,
 * přičemž jednotlivé čtveřice čísel budou odděleny znaky podtržení.
 *
 * @param number    Převáděné číslo
 * @return Požadovaný binírní tvar čísla
 */
String toShortBin(long number)
{
    return x2bin(number, 16);
}


/**************************************************************************
 * Převede zadané číslo do úplného binárního tvaru s 8 číslicemi,
 * přičemž jednotlivé čtveřice čísel budou odděleny znaky podtržení.
 *
 * @param number    Převáděné číslo
 * @return Požadovaný binírní tvar čísla
 */
String toByteBin(long number)
{
    return x2bin(number, 8);
}


/**************************************************************************
 * Převede zadané číslo do úplného hexadecimálního tvaru s 16 číslicemi,
 * přičemž jednotlivé čtveřice čísel budou odděleny znaky podtržení.
 *
 * @param number    Převáděné číslo
 * @return Požadovaný hexadecimální tvar čísla
 */
String toLongHex(long number)
{
    return x2hex(number, 16);
}


/**************************************************************************
 * Převede zadané číslo do úplného hexadecimálního tvaru s 8 číslicemi,
 * přičemž jednotlivé čtveřice čísel budou odděleny znaky podtržení.
 *
 * @param number    Převáděné číslo
 * @return Požadovaný hexadecimální tvar čísla
 */
String toIntHex(long number)
{
    return x2hex(number, 8);
}


/**************************************************************************
 * Převede zadané číslo do úplného hexadecimálního tvaru se 4 číslicemi.
 *
 * @param number    Převáděné číslo
 * @return Požadovaný hexadecimální tvar čísla
 */
String toShortHex(long number)
{
    return x2hex(number, 4);
}


/**************************************************************************
 * Převede zadané číslo do úplného hexadecimálního tvaru se 2 číslicemi.
 *
 * @param number    Převáděné číslo
 * @return Požadovaný hexadecimální tvar čísla
 */
String toByteHex(long number)
{
    return x2hex(number, 2);
}



/*************************************************************************/

boolean _boolean;
byte _byte;
short _short;
int _int;
long _long;
float _float;
double _double;
char _char;
Object _Object;
String _String = "String";



/*************************************************************************/
