package b72_j21ref.c16_constructors;
/* M:/72_Java/b72_j21ref/c16_constructors/This.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */
import java.util.Date;



/*******************************************************************************
 * Třída {@code Constructors} a její instance slouží pro demonstrace
 * a experimenty při výkladu zavádění a inicializaci tříd
 * a konstrukci jejích instancí.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class Constructors
{
    static  //Úvodní statický inicializační blok
    {/*## 1 ##*/
        //Tady metoda tiskne všechny atributy ještě před tím,
        //než jsou inicializovány. To by měla být syntaktická chyba,
        //ale tím, že je to skryté v metodě, tak to překladač neodhalí.
        printStaticAttributes("Konstrukce třídy Konstruktory - START");
    }

    //Úvodní instanční inicializační blok
    {/*## 2 ##*/
        System.out.println("\n-------------------------------------" +
                           "\nSTART inicializace pro " + this);
    }



//\CC== CLASS CONSTANTS (CONSTANT CLASS/STATIC ATTRIBUTES/FIELDS) ==============

    static  //Před deklarací konstant
    {/*## 3 ##*/
        //Použití nedeklarované konstanty je syntaktická chyba,
        //i kdyby už měla hodnotu přiřazenou při překladu
//        System.out.println("COMPILED:    " + COMPILED );
        //Skryté použití ale projde – viz tisk v úvodním bloku
    }

    /** Konstanta inicializovaná v době překladu - je-li hodnota konstanty
     *  známa v době překladu, inicializuje ji už překladač. */
    private static final String COMPILED = "COMPILED";

    /** Konstanta inicializovaná až při zavádění třídy. */
    public static final Class<?> CLASS_OBJECT = Constructors.class;

    /** Konstanta inicializovaná až při zavádění třídy. */
    public static final String COMPUTED;

    static  //Po deklaraci konstant
    {/*## 4 ##*/
//        //Dosud neinicializovaná konstanta se také nesmí používat
//        System.out.println("COMPUTED: " + COMPUTED);

        COMPUTED = CLASS_OBJECT.getName();

        //Po inicializaci se konstanty již smí používat
        System.out.println("\nxxx Tisk po inicializaci třídních konstant:" +
                           "\n    - PŘELOŽENÁ:    " + COMPILED     +
                           "\n    - CLASS_OBJEKT: " + CLASS_OBJECT +
                           "\n    - SPOČTENÁ:     " + COMPUTED     );
    }

    /** Atributem třídy může být i instance dané třídy.
     *  Je však třeba dbát na to, aby byl tento atribut inicializován
     *  až po inicializaci všech atributů třídy,
     *  které jsou při jeho inicializaci používány.
     *  Následující deklarace má problém s konstantním atributem
     *  {@link #LOADED} deklarovaným až na samém konci zdrojového kódu,
     *  stejně jako s atributem {@link #countCreated} deklarovaným vzápětí.
     *  Problémy se odstraní přemístěním inicializace atributu
     *  za všechny inicializace atributů třídy. */
    public static final Constructors ME = new Constructors();



//\CV== CLASS VARIABLES (VARIABLE CLASS/STATIC ATTRIBUTES/FIELDS) ==============

    static //Před deklarací proměnných
    {/*## 5 ##*/
//        //Nedeklarovaná proměnná se také nesmí používat
//        System.out.println("variable: " + variable );
    }

    private static String variable;
    private static int    countCreated = 0;

    static  //Po deklaraci proměnných
    {/*## 6 ##*/
        //Proměnná se smí používat i neinicializovaná
        System.out.println("\nxxx Tisk po deklaraci třídních proměnných:" +
                           "\n    - variable:    " + variable);
        variable = "VARIABLE";  //Proměnná je inicializována až teď
    }



//##############################################################################
//\CI== CLASS (STATIC) INITIALIZER (CLASS CONSTRUCTOR) =========================

    //Sekce pro umístění případného statického inicializačního bloku
    static {
        //Vzhledem k výše popsaným pravidlům by se měl statický inicializační
        //blok umisťovat až za všechny deklarace statických atributů.
        //Pak může jednoduše inicializovat všechny statické atributy,
        //které není možno jednoduše inicializovat přímo v jejich deklaracích,
        //a případně provést i některé další potřebné akce
        //spojené se zaváděním třídy.
    }



//\CM== CLASS (STATIC) REMAINING NON-PRIVATE METHODS ===========================

    /***************************************************************************
     * Vytiskne na standardní výstup všechny statické atributy třídy
     *
     * @param title Nadpis před jednotlivými tisky
     */
    public static void printStaticAttributes(String title)
    {
        System.out.println("\n" + title +
                           "\n  - PŘELOŽENÁ="    + COMPILED    +
                              ",  CLASS_OBJEKT=" + CLASS_OBJECT +
                              ",  proměnná="     + variable     +
                              ",  počet="        + countCreated        +
                           "\n    ZAVEDENO="     + LOADED
                         );
    }



//\CP== CLASS (STATIC) PRIVATE AND AUXILIARY METHODS ===========================

    /***************************************************************************
     * Pomocná statická metoda sloužící k zaznamenání okamžiku,
     * kdy se vyhodnocují parametry osloveného konstruktoru.
     *
     * @param text Označení oslovovaného konstruktoru
     * @return Text zadaný jako parametr
     */
    private static String prepare(String text)
    {
        System.out.println("  === Přípravuji parametr pro: " + text +
                         "\n      Čas=" + new Date());
        return text;
    }



//##############################################################################
//\IC== INSTANCE CONSTANTS (CONSTANT INSTANCE ATTRIBUTES/FIELDS) ===============

    //V inicializaci instančních atributů se smí používat pouze
    //dříve deklarované instanční atributy a již inicializované konstanty
    //Atributy třídy se však smí používat všechny, protože ty mají být
    //v době inicializace instance už dávno připraveny
    private final String loaded = LOADED;

    private final int ID;
    //"Rodné číslo" instance je nutno nejprve spočítat
    {/*## 7 ##*/
        countCreated = countCreated + 1; //Zvětším statický atribut
        ID           = countCreated;     //a zapamatuji si jeho aktuální hodnotu
        System.out.println("Atribut ID inicializován: " + this);
    }



//\IV== INSTANCE VARIABLES (VARIABLE INSTANCE ATTRIBUTES/FIELDS) ===============

    //V inicializaci instance je povoleno použití parametru this
    //V následující inicializaci se ptám instance na její class-objekt
    private String name = "[" + this.getClass() + "]"; //Prozatímní název

    private String source;



//##############################################################################
//\II== INSTANCE INITIALIZERS (CONSTRUCTORS) ===================================

    /***************************************************************************
     * Bezparametrický konstruktor pro test inicializace.
     */
    public Constructors()
    {
        System.out.println("Vstup do těla konstruktoru " + this);
        source = "Bezparametrický";
        System.out.println("Konec těla konstruktoru " + this);
    }


    /***************************************************************************
     * Jednoparametrický konstruktor pro test delegace zodpovědnosti.
     *
     * @param name Název vytvářené instance
     */
    public Constructors(String name)
    {
        //Před předáním odpovědnosti nesmí nic být
//        System.out.println("1-parametrický pro " + this);
        this(name, prepare("1-parametrický"));
        System.out.println("Konec 1-parametrický");
    }


    /***************************************************************************
     * Dvouparametrický konstruktor pro test delegace zodpovědnosti.
     *
     * @param name Název vytvářené instance
     * @param source Charakteristika  žadatele
     */
    public Constructors(String name, String source)
    {
        this(name, prepare("2-parametrický"), source);
        String lok = "2-parametrický";
        System.out.println("Konec " + lok);
    }


    /***************************************************************************
     * Tříparametrický konstruktor pro test delegace zodpovědnosti.
     *
     * @param name      Název vytvářené instance
     * @param source    Charakteristika  žadatele
     * @param preSource Druhá část hodnoty atributu {@code zdroj}
     */
    public Constructors(String name, String source, String preSource)
    {
        System.out.println("Vstup do těla 3-parametrického pro " + this +
        "\n   Parametry: Název=" + name + ", Zdroj=" + source +
                                       ", Prazdroj=" + preSource);
        String notUsed;
        String underscore;
        this.name    = name;
        String suma  = "«" + preSource + " -> " + source + "»";
        this.source  = suma;
        String local = "Konec 3-parametrický: ";
        underscore = "\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~";
        System.out.println(local + this + underscore);
    }



//\IM== INSTANCE REMAINING NON-PRIVATE METHODS =================================

    /***************************************************************************
     * Vrací textový podpis dané instance.
     *
     * @return Textový podpis dané instance
     */
    @Override
    public String toString()
    {
        return "Konstruktory_" + ID + "(název=" + name + ", zdroj=" + source +
               ", zavedeno=" + loaded + ")";
    }



//##############################################################################

    {/*## 8 ##*/
        System.out.println("STOP inicializace instance " + this +
                         "\n----------------------------");
    }

    //Statický atribut deklarovaný až na konci těla
    private static final String LOADED = "ZAVEDENO: " + new java.util.Date();
    static
    {/*## 9 ##*/
        printStaticAttributes("\nKonstrukce třídy Konstruktory - STOP");
        System.out.println(      "====================================\n");
    }
}
