package b72_j21ref.c21_exceptions;
/* M:/72_Java/b72_j21ref/c99_templates/NewClass.java
Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó.
*/


/*******************************************************************************
 * Třída Instance třídy {@code NewClass} představují ...
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 0.00.0000 — 20yy-mm-dd
 */
public class ExceptionChecking
{
//\IM== INSTANCE GENERAL NON-PRIVATE METHODS ===================================



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================

    /***************************************************************************
     * Metoda, která může vyhodit kontrolovanou výjimku, to musí hlásit.
     */  static
    void throwsChecked() throws CheckedException {
        throw new CheckedException("Kontrolovaná výjimka");
    }


    /***************************************************************************
     * Vyhazování nekontrolované výjimky se hlásit nemusí...
     */  static
    void throwsUnchecked_() {
        throw new UncheckedException("Nekontrolovaná výjimka");
    }


    /***************************************************************************
     * Vyhazování nekontrolované výjimky se hlásit nemusí, ale může.
     */  static
    void throwsUnchecked() throws UncheckedException {
        throw new UncheckedException("Nekontrolovaná výjimka");
    }
    /***************************************************************************
     * Neohlášení možného vyhození kontrolované výjimky je syntaktická chyba.
     */ static
    void callThrowingMtd_(boolean perform) {
//        if (perform) { throwsChecked(); }
    }


    /***************************************************************************
     * Jakmile možné vyhození deklaruji, překladač se uklidní.
     */  static
    void callThrowingMtd(boolean perform) throws CheckedException {
        if (perform) { throwsChecked(); }
        throwsUnchecked();   //Toto hlásit nemusím
    }


    /***************************************************************************
     * Když výjimku zachytím a nehrozí, že ji vyhodím dál, nic nehlásím.
     */  static
    void exceptionChecked() {
        try {
            throwsChecked();
        }
        catch(CheckedException e) {
            System.out.println("Ošetřena kontrolovaná výjimka: " + e);
        }
    }



//##############################################################################
//== MAIN METHOD ===============================================================

    /***************************************************************************
     * Metoda spouštějící aplikaci - hlavnímetoda aplikace.
     *
     * @param args Parametry příkazového řádku
     */
    public static void main(String[] args)
    {
        try {
            callThrowingMtd(true);
            callThrowingMtd(false);
            exceptionChecked();
        } catch(Exception e) {}
        System.exit(0);
    }

}
