package b72_j21ref.c21_exceptions;
/* M:/72_Java/b72_j21ref/c21_exceptions/ThrowCatchTest.java
Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó.
*/


/*******************************************************************************
 * Třída Instance třídy {@code ThrowCatchTest} demonstrují použití
 * více bloků catch + bloku finally
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 0.00.0000 — 20yy-mm-dd
 */
public class ThrowCatchTest
{
//\IM== INSTANCE GENERAL NON-PRIVATE METHODS ===================================

    void multiThrow(int h)
    {
        if (h<0) { throw new Error("CHYBA - Podteklo to"); }
        int    h0 = 1 / h;                  //h=0 => ArithmeticException
        String h7 = (h%3 == 0) ?  null  :  "";
               h7.toString();               //h=3 => NullPointerException
        char   hM = "ABCDEF".charAt(h + 3); //h>1 => IndexOutOfBoundsException
        System.out.println("      Pro h=" + h + " metoda multiThrow prošla");
    }


    void catchTest(int level)
    {
        System.out.println("+++++ Příchod na hladinu "  + level);
        String zpráva =    "      Hladina " + level + ": ";
        try {
            multiThrow(level);
            zpráva += "Test v pořádku";
        }
        catch(ArithmeticException | NullPointerException  e)
        {
            zpráva += "Nastala výjimka typu " + e;
        }
        catch(IndexOutOfBoundsException e) {
            zpráva += "Index mimo meze";
        }
        catch(RuntimeException e) {
            zpráva += "Někde se stala chyba typu " + e.getClass().getSimpleName();
        }
        catch(Throwable e) {
            zpráva += "Něco se stalo - " + e.getClass().getName()
                   + "\n      Příčina: " + e.getMessage();
            throw new RuntimeException("Utíkám z hladiny " + level);
        }
        finally {
            System.out.println(zpráva);
        }
        System.out.println("----- Konec akce v hladině " + level);
        catchTest(level-1);
    }



//##############################################################################
//== MAIN METHOD ===============================================================

    /***************************************************************************
     * Metoda spouštějící aplikaci - hlavnímetoda aplikace.
     *
     * @param args Parametry příkazového řádku
     */
    public static void main(String[] args)
    {
        new ThrowCatchTest().catchTest(4);
        System.exit(0);
    }

}
