package b72_j21ref.c28_lambda;
/* M:/72_Java/b72_j21ref/c28_lambda/ShapeLight.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */

import ruplib.canvasmanager.Ellipse;
import ruplib.canvasmanager.ICMPaintable;
import ruplib.canvasmanager.ICMShape;
import ruplib.canvasmanager.Painter;
import ruplib.geom.AModular;
import ruplib.util.IColorable;
import ruplib.util.NamedColor;

import java.util.function.Supplier;



/*******************************************************************************
 * Instance představují světla, která je možné rozsvítit a zhasnout
 * přičemž je možno při konstrukci světla zadat tvar představující žárovku.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023_Summer
 */
public class ShapeLight extends AModular implements ICMPaintable
{
//\CC== CLASS CONSTANTS (CONSTANT CLASS/STATIC ATTRIBUTES/FIELDS) ==============

    /** Implicitní továrna na žárovky. */
    private static final Supplier<Ellipse> DEFAULT_FACTORY = Ellipse::new;



//##############################################################################
//\IC== INSTANCE CONSTANTS (CONSTANT INSTANCE ATTRIBUTES/FIELDS) ===============

    /** Barva rozsvíceného světla. */
    private final NamedColor color;

    /** Obrazec představující žárovku schopnou se nechat zobrazit
     *  správcem plátna, zkopírovat se a měnit pozici a rozměr. */
    private final ICMShape cmShapeBulb;

    /** Obrazec představující žárovku schopnou měnit svoji barvu. */
    private final IColorable colorableBulb;

    /** Tovární objekt na výrobu žárovek. */
    private final Supplier<?> bulbFactory;



//\II== INSTANCE INITIALIZERS (CONSTRUCTORS) ===================================

    /***************************************************************************
     * Vytvoří světlo zadaných rozměrů a zadané barvy rozsvíceného světla
     * umístěné na zadaných souřadnicích, přičemž jeho žárovka je vytvářena
     * pomocí zadané tovární metody, která tak definuje podobu světla.
     *
     * @param <B>         Typ objektu, který bude představovat žárovku
     * @param x           Vodorovná souřadnice vytvářeného světla
     * @param y           Svislá souřadnice vytvářeného světla
     * @param size        Velikost vytvářeného světla
     * @param color       Barva rozsvíceného světla
     * @param bulbFactory Tovární objekt na výrobu žárovek
     */
    public <B extends ICMShape & IColorable>
    ShapeLight(int x, int y, int size, NamedColor color,
               Supplier<B> bulbFactory)
    {
        super(x, y, size);
        this.color = color;
        B bulb = bulbFactory.get();
        this.bulbFactory    = bulbFactory;
        this.cmShapeBulb    = bulb;
        this.colorableBulb  = bulb;

        cmShapeBulb  .setPosition(x, y);
        cmShapeBulb  .setSize(size, size);
        colorableBulb.setColor(color);
    }


    /***************************************************************************
     * Vytvoří světlo implicitního tvaru, rozměrů a barvy rozsvíceného světla
     * umístěné v levém horním rohu.
     */
    public ShapeLight() {
        this(0, 0, 100, NamedColor.AMBER, DEFAULT_FACTORY);
    }


    /** Tovární metoda vracející kopii daného objektu. */
    @SuppressWarnings("unchecked")
    public ShapeLight copy() {
        var copy = new ShapeLight(getX(), getY(), getModule(), color,
                                  (Supplier)bulbFactory);
        return copy;
    }



//\IG== INSTANCE GETTERS AND SETTERS ===========================================

    /** Prozradí, je-li světlo rozsvícené. */
    public boolean isOn() {
        return color.equals(colorableBulb.getColor());
    }


    /** Nastaví novou pozici instance. */
    @Override
    public void setPosition(int x, int y) {
        super      .setPosition(x, y);
        cmShapeBulb.setPosition(x, y);
    }


    /** Změni velikost instance. */
    @Override
    public void setModule(int module) {
        super      .setModule(module);
        cmShapeBulb.setSize  (module);
    }



//\IM== INSTANCE REMAINING NON-PRIVATE METHODS =================================

    /** Prostřednictvím dodaného kreslítka vykreslí obraz své instance. */
    @Override
    public void paint(Painter painter) {
        cmShapeBulb.paint(painter);
    }


    /** Zhasne dané světlo, tj. vybarví je barvou pro zhasnuté světlo. */
    public void switchOff() {
        colorableBulb.setColor(NamedColor.BLACK);
    }


    /** Rozsvítí dané světlo, tj. vybarví je barvou rozsvíceného světla. */
    public void switchOn() {
        colorableBulb.setColor(color);
    }


    /** Vrátí textový podpis instance. */
    @Override
    public String toString() {
        return getClass().getSimpleName() + "{" + super.forToString()
             + ", color=" + color + ", on=" + isOn() + '}';
    }

}
