/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.geom;



////////////////////////////////////////////////////////////////////////////////
//%P-  +++++ End of ignored starting text - place for imports ++++++++++++++++++



/*******************************************************************************
 * Třída AChangeable je společnou rodičovskou třídou tříd implementujících
 * interfejs IChangeable.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public abstract class AModular
              extends AMovable
           implements IModular
{
//== CONSTANT CLASS FIELDS =====================================================
//== VARIABLE CLASS FIELDS =====================================================



//##############################################################################
//== STATIC INITIALIZER (CLASS CONSTRUCTOR) ====================================
//== CLASS GETTERS AND SETTERS =================================================
//== OTHER NON-PRIVATE CLASS METHODS ===========================================
//== PRIVATE AND AUXILIARY CLASS METHODS =======================================



//##############################################################################
//== CONSTANT INSTANCE FIELDS ==================================================
//== VARIABLE INSTANCE FIELDS ==================================================

    /** Velikost modulu = délka strany opsaného čtverce. */
    private int module;



//##############################################################################
//== CONSTRUCTORS AND FACTORY METHODS ==========================================

    /***************************************************************************
     * Vytvoří na zadaných souřadnicích instanci se zadanou velikostí (modulem).
     *
     * @param x       Vodorovná (x-ová) souřadnice instance,
     *                x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y       Svislá (y-ová) souřadnice instance,
     *                y=0 má horní okraj plátna, souřadnice roste dolů
     * @param module  Velikost modulu = délka strany opsaného čtverce,
     *                module &gt;= 0
     */
    public AModular(int x, int y, int module)
    {
        super( x, y );
        //Test platnosti parametru
        if( module<0) {
            throw new IllegalArgumentException(
                "\n" + getClass() + "Parametry nemají povolené hodnoty: modul="
                     + module );
        }
        //Parametry akceptovány --> můžeme tvořit
        this.module = module;
    }



//== ABSTRACT METHODS ==========================================================
//== INSTANCE GETTERS AND SETTERS ==============================================

    /***************************************************************************
     * Vrátí velikost modulu (= délku strany opsaného čtverce) v bodech.
     *
     * @return  Aktuální velikost modulu v bodech
     */
     @Override
     final public int getModule()
     {
         return module;
     }


    /***************************************************************************
     * Změni velikost instance, aby měl její nový modul
     * (= délka strany opsaného čtverce) zadanou velikost.
     *
     * @param module    Nově nastavovaný modul
     */
    @Override
    public void setModule(int module)
    {
        if (module != this.module) {
            if (module < 0) {
                throw new IllegalArgumentException(
                    "Rozměry musí byt nezáporné: modul=" + module);
            }
            this.module = module;
        }
    }



//== OTHER NON-PRIVATE INSTANCE METHODS ========================================

    /***************************************************************************
     * Vrací charakteristiky dané instance do jejího podpisu.
     *
     * @return Charakteristiky dané instance
     */
    @Override
    protected String forToString()
    {
        return super.forToString() +
               ", modul=" + getModule();
    }



//== PRIVATE AND AUXILIARY INSTANCE METHODS ====================================



//##############################################################################
//== NESTED DATA TYPES =========================================================
}
