/* The file is saved in UTF-8 codepage.
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.geom;



/*******************************************************************************
 * Třída {@code AShape} je společným rodičem grafických objektů
 * zobrazitelné prostřednictvím správce plátna &ndash; instance třídy 
 * {@link ruplib.canvasmanager.CanvasManager CanvasManager}.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public abstract class AShape
              extends AChangeable
           implements IShape
{
//== CONSTANT CLASS FIELDS =====================================================
//== VARIABLE CLASS FIELDS =====================================================



//##############################################################################
//== STATIC INITIALIZER (CLASS CONSTRUCTOR) ====================================
//== CLASS GETTERS AND SETTERS =================================================
//== OTHER NON-PRIVATE CLASS METHODS ===========================================
//== PRIVATE AND AUXILIARY CLASS METHODS =======================================



//##############################################################################
//== CONSTANT INSTANCE FIELDS ==================================================
//== VARIABLE INSTANCE FIELDS ==================================================



//##############################################################################
//== CONSTRUCTORS AND FACTORY METHODS ==========================================

    /***************************************************************************
     * Vytvoří na zadaných souřadnicích instanci se zadanou šířkou a výškou.
     *
     * @param x       Vodorovná (x-ová) souřadnice instance,
     *                x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y       Svislá (y-ová) souřadnice instance,
     *                y=0 má horní okraj plátna, souřadnice roste dolů
     * @param width   Šířka vytvářené instance, šířka &gt;= 0
     * @param height  Výška vytvářené instance, výška &gt;= 0
     */
    public AShape(int x, int y, int width, int height)
    {
        super(x, y, width, height);
    }



//== ABSTRACT METHODS ==========================================================

    /***************************************************************************
     * Vrátí svoji kopii, tj. instanci s naprosto shodnými vlastnostmi
     * s výjimkou těch, které podle kontraktu shodné být nesmějí.
     *
     * @return Požadovaná kopie
     */
    @Override
    public abstract AShape copy();



//== INSTANCE GETTERS AND SETTERS ==============================================
//== OTHER NON-PRIVATE INSTANCE METHODS ========================================
//== PRIVATE AND AUXILIARY INSTANCE METHODS ====================================



//##############################################################################
//== NESTED DATA TYPES =========================================================
}
