/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.geom;



/*******************************************************************************
 * Instance třídy {@code Pozice} představují přepravky uchovávající informace
 * o pozici objektu.
 * Proto jsou jejich atributy deklarovány jako veřejné konstanty.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class Position
{
//\CC== CLASS CONSTANTS (CONSTANT CLASS/STATIC ATTRIBUTES/FIELDS) ==============

    /** Hodnota indikující, že hash-code ještě nebyl spočítán. */
    private static final int INIT_HASH_CODE = Integer.MIN_VALUE;


//\CV== CLASS VARIABLES (VARIABLE CLASS/STATIC ATTRIBUTES/FIELDS) ==============



//##############################################################################
//\CI== CLASS (STATIC) INITIALIZER (CLASS CONSTRUCTOR) =========================
//\CF== CLASS (STATIC) FACTORY METHODS =========================================
//\CG== CLASS (STATIC) GETTERS AND SETTERS =====================================
//\CM== CLASS (STATIC) REMAINING NON-PRIVATE METHODS ===========================
//\CP== CLASS (STATIC) PRIVATE AND AUXILIARY METHODS ===========================



//##############################################################################
//\IC== INSTANCE CONSTANTS (CONSTANT INSTANCE ATTRIBUTES/FIELDS) ===============

    /** Vodorovná souřadnice. */
    public final int x;

    /** Svislá souřadnice. */
    public final int y;



//\IV== INSTANCE VARIABLES (VARIABLE INSTANCE ATTRIBUTES/FIELDS) ===============

    /** Jednou spočtený hash-kód se pak již pouze předává, ale už nepočítá. */
    private int hashCode = INIT_HASH_CODE;



//##############################################################################
//\II== INSTANCE INITIALIZERS (CONSTRUCTORS) ===================================

    /***************************************************************************
     * Vytvoří přepravku uchovávající zadané souřadnice.
     *
     * @param x  Vodorovná souřadnice
     * @param y  Svislá souřadnice
     */
    public Position(int x, int y)
    {
        this.x = x;
        this.y = y;
    }



//\IA== INSTANCE ABSTRACT METHODS ==============================================
//\IG== INSTANCE GETTERS AND SETTERS ===========================================

    /***************************************************************************
     * Vrátí velikost vodorovné souřadnice.
     *
     * @return  Velikost vodorovné souřadnice
     */
    public int getX()
    {
        return x;
    }


    /***************************************************************************
     * Vrátí velikost svislé souřadnice.
     *
     * @return  Velikost svislé souřadnice
     */
    public int getY()
    {
        return y;
    }



//\IM== INSTANCE REMAINING NON-PRIVATE METHODS =================================

    /***************************************************************************
     * Vrátí informaci o tom, představuje-li instance zadaná v parametru
     * stejnou pozici.
     *
     * @param  object  Testovaná instance
     * @return Je-li zadaná instance pozicí se stejnými hodnotami atributů,
     *         vrátí {@code true}, jinak vrátí {@code false}.
     */
    @Override
    public boolean equals(Object object)
    {
        return (object instanceof Position)      &&
               (((Position)object).x == this.x)  &&
               (((Position)object).y == this.y);
    }


    /***************************************************************************
     * Vrátí hash-kód dané instance.
     *
     * @return  Hash-kód
     */
    @Override
    public int hashCode()
    {
        if (hashCode == INIT_HASH_CODE) {
            hashCode = 5;
            hashCode = 83 * hashCode + this.x;
            hashCode = 83 * hashCode + this.y;
        }
        return hashCode;
    }


    /***************************************************************************
     * Vrací textovou reprezentaci (podpis) dané instance.
     * Používá se především k ladicím účelům.
     *
     * @return Podpis dané instance
     */
    @Override
    public String toString()
    {
        return "Position[x=" + x + ", y=" + y + "]";
    }



//\IP== INSTANCE PRIVATE AND AUXILIARY METHODS =================================



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
