#include <iostream>
#include <string>
using namespace std;

enum jednotka {den, mesic, rok};

const int POCET_MESICU = 12;
const int POCET_SLOZEK = 3;

const int pocet_dnu_v_mesici[POCET_MESICU + 1] = {0, 31, 28, 31, 30, 31, 
                     30, 31, 31, 30, 31, 30, 31};

int pocet_dnu_do_zacatku[POCET_MESICU + 1]{};
string nazev[] = {"Den"s, "Mesic"s, "Rok"s};

void priprava()
{
    for(int i = 1; i <= POCET_MESICU; i++)
    {
        pocet_dnu_do_zacatku[i] = pocet_dnu_do_zacatku[i-1] + pocet_dnu_v_mesici[i-1];
    }
}

bool prestupny(int rok)
{
    return ((rok % 4 == 0) && (rok % 100 != 0)) || (rok % 400 == 0);
}

void zadost(int datum[])
{
    cout << "Zadej prosím datum." << endl;
    for(int i = den; i <= rok; i++)
    {
        cout << nazev[i] << ": ";
        cin >> datum[i];
    }
}

int cislo_dne(int datum[])
{
    int vysledek = pocet_dnu_do_zacatku[datum[mesic]] + datum[den];
    if(prestupny(datum[rok]) && datum[1] > 2)
    {
        vysledek++;
    }
    return vysledek;
}

void vypis_data(int datum[])
{
    for(int i = den; i <= rok; i++)
    {
        cout << datum[i] << ((i < rok) ? ". " : " ");
    }
}

int main()
{
    priprava();
    int datum[POCET_SLOZEK];
    zadost(datum);
    vypis_data(datum);
    cout << " je " << cislo_dne(datum) << ". den v roce." << endl;
    return 0;
}