#include <iostream>

using namespace std;

const char MALA[] = "áčďéěíňóřšťúůýž";
const char VELKA[] = "ÁČĎÉĚÍŇÓŘŠŤÚŮÝŽ";

int delka(const char text[])
{
    int i = 0;
    while(text[i])
    {
        i++;
    }
    return i;
}


int najdi(char c)
{
    for (int i = 0; MALA[i]; i++)
    {
        if (MALA[i] == c)
        {
            return i;
        }
    }
    return -1;
}

char diakritika_na_velka(char c)
{
    int index = najdi(c);
    return index == -1 ? c : VELKA[index];
}

char na_velka(const char c)
{
    return (c >= 'a' && c <= 'z') ? c - 'a' + 'A' : diakritika_na_velka(c);
}

void na_velka(char text[])
{
    int i = 0;
    while (text[i])
    {
        text[i] = na_velka(text[i]);
        i++;
    }
}

char txt[] = R"(
žluťoučký kůň 
příšerně úpěl 
ďábelské ódy)";

int main()
{
    cout << delka(MALA) << endl;
    na_velka(txt);
    cout << txt << endl;
    return 0;
}