#include <iostream>
#include <string>
#include <sstream>

using namespace std;

#include "datum.h"

const int POCET_MESICU = 12;

int pocet_dnu_do_zacatku[POCET_MESICU + 1]{};

const int pocet_dnu_v_mesici[POCET_MESICU + 1] = {0, 31, 28, 31, 30, 31, 
                     30, 31, 31, 30, 31, 30, 31};
                     
const string jmeno_mesice[]{ "", "ledna", "února", "března",
           "dubna", "května", "června", "července", "srpna", 
           "září", "října", "listopadu", "prosince" };



void priprava()
{
    for(int i = 1; i <= POCET_MESICU; i++)
    {
        pocet_dnu_do_zacatku[i] = pocet_dnu_do_zacatku[i-1] + pocet_dnu_v_mesici[i-1];
    }
}

bool datum::prestupny_rok()
{
    return ((rok % 4 == 0) && (rok % 100 != 0)) || (rok % 400 == 0);
}

datum::datum(int _den, int _mesic, int _rok)
{
    nastav_den(_den);
    nastav_mesic(_mesic);
    nastav_rok(_rok);
}


int datum::cislo_dne()
{
    int vysledek = pocet_dnu_do_zacatku[mesic] + den;
    if(prestupny_rok() && mesic > 2)
    {
        vysledek++;
    }
    return vysledek;
}

string datum::na_retezec(format_data format)
{
    ostringstream vystup;
    vystup << den << ". ";
    vystup << ((format == kratky || format == stredni) 
               ? std::to_string(mesic) + ". "s 
               : jmeno_mesice[mesic] + " "s); 
    vystup << ((format == kratky) ? rok % 1000 : rok);
    return vystup.str();

}

datum datum::zitra()
{
    datum vysledek{den, mesic, rok};
    vysledek.den++;
    if(vysledek.kontrola())
    {
        return vysledek;
    }
    vysledek.den = 1;
    vysledek.mesic++;
    if(vysledek.kontrola())
    {
        return vysledek;
    }
    vysledek.mesic = 1;
    vysledek.rok++;
    return vysledek;
}

bool datum::kontrola()
{
    if((mesic <= 0) || (mesic > POCET_MESICU))
    {
        return false;
    }
    if((den> 0) && (den <= pocet_dnu_v_mesici[mesic]))
    {
        return true;
    }
    if(den == 29 && mesic == 2 && prestupny_rok())
    {
        return true;
    }
    return false;
}


