#include <iostream>
#include <string>
#include <sstream>

using namespace std;

#include "datum.h"



void datum::priprava()
{
    for (int i = 1; i <= POCET_MESICU; i++)
    {
        pocet_dnu_do_zacatku[i] = pocet_dnu_do_zacatku[i - 1] + pocet_dnu_v_mesici[i - 1];
    }
}

bool datum::prestupny_rok(int rok)
{
    return ((rok % 4 == 0) && (rok % 100 != 0)) || (rok % 400 == 0);
}

datum::datum(int _den, int _mesic, int _rok)
{
    //cout << "konstruktor" << endl;
    nastav_den(_den);
    nastav_mesic(_mesic);
    nastav_rok(_rok);
    pocet_instanci++;
}

datum::datum(datum& _datum)
{
    //cout << "kopírovací konstruktor" << endl;
    for (int i = 0; i < 3; i++)
    {
        slozka[i] = _datum.slozka[i];
    }
    pocet_instanci++;
}



int datum::cislo_dne() const
{
    int vysledek = pocet_dnu_do_zacatku[mesic()] + den();
    if (prestupny_rok(rok()) && mesic() > 2)
    {
        vysledek++;
    }
    return vysledek;
}

string datum::na_retezec(format_data format) const
{
    ostringstream vystup;
    vystup << den() << ". ";
    vystup << ((format == kratky || format == stredni)
        ? to_string(mesic()) + ". "s
        : jmeno_mesice[mesic()] + " "s);
    vystup << ((format == kratky) ? rok() % 1000 : rok());
    return vystup.str();
}

datum datum::zitra() 
{
    /* datum vysledek{den, mesic, rok};
    //datum vysledek(*this);
    vysledek.den++;
    if (vysledek.kontrola())
    {
        return vysledek;
    }
    vysledek.den = 1;
    vysledek.mesic++;
    if (vysledek.kontrola())
    {
        return vysledek;
    }
    vysledek.mesic = 1;
    vysledek.rok++;
    return vysledek;*/
    
    datum vysledek(*this);
    for (int i = 0; i < 2; i++)
    {
        vysledek.slozka[i]++;
        if (vysledek.kontrola())
        {
            return vysledek;
        }
        vysledek.slozka[i] = 1;
    }
    vysledek.slozka[2]++;
    return vysledek;
}

bool datum::kontrola() const
{
    if ((mesic() <= 0) || (mesic() > POCET_MESICU))
    {
        return false;
    }
    if ((den() > 0) && (den() <= pocet_dnu_v_mesici[mesic()]))
    {
        return true;
    }
    if (den() == 29 && mesic() == 2 && prestupny_rok(rok()))
    {
        return true;
    }
    return false;
}

const int datum::pocet_dnu_v_mesici[POCET_MESICU + 1] = { 0, 31, 28, 31, 30, 31,
                     30, 31, 31, 30, 31, 30, 31 };

int datum::pocet_dnu_do_zacatku[POCET_MESICU + 1]{};
const string datum::jmeno_mesice[]{ "", "ledna", "února", "března",
           "dubna", "května", "června", "července", "srpna",
           "září", "října", "listopadu", "prosince" };

unsigned datum::pocet_instanci = 0;