#ifndef __DATUM_H__
#define __DATUM_H__
#include <string>
using namespace std;

enum format_data { kratky, stredni, dlouhy };

class datum
{
public:
    static const int POCET_MESICU = 12;
    datum(int _den, int _mesic, int _rok);
    datum(datum& _datum);
    ~datum() { pocet_instanci--; }
    void nastav_den(int _den) { slozka[0] = _den; }
    void nastav_mesic(int _mesic) { slozka[1] = _mesic; }
    void nastav_rok(int _rok) { slozka[2] = _rok; }
    int den() const { return slozka[0]; }
    int mesic() const { return slozka[1]; }
    int rok() const { return slozka[2]; }
    int cislo_dne() const;
    static bool prestupny_rok(int rok);
    string na_retezec(format_data format) const;
    datum zitra();
    bool kontrola() const;
    static void priprava();
    static unsigned pocet() { return pocet_instanci; }
private:
    int slozka[3]{};
    static int pocet_dnu_do_zacatku[POCET_MESICU + 1];
    static const int pocet_dnu_v_mesici[POCET_MESICU + 1];
    static const string jmeno_mesice[];
    static unsigned pocet_instanci;
};

#endif // __DATUM_H__