#ifndef __DATUM_H__
#define __DATUM_H__
#include <string>

using namespace std;

enum format_data { kratky, stredni, dlouhy };

class Datum
{
public:
	struct datum
	{
		int den, mesic, rok;
	};
	static const int POCET_MESICU = 12;
	static const int pocet_dnu_v_mesici[POCET_MESICU + 1];
	static const string jmeno_mesice[];
	Datum(int cisloDne) : jul_cislo_dne(cisloDne), obvykle_datum{ datum_z_jul_cisla_dne(cisloDne) }{}
	Datum(int den, int mesic, int rok);
	Datum(datum _datum) : Datum(_datum.den, _datum.mesic, _datum.rok) {}
	static bool prestupny_rok(int rok);
	string na_retezec(format_data format) const;
	Datum zitra() const;
	int cislo_dne_v_roce() const;
	int den() const;
	int mesic() const;
	int rok() const;
	datum aktualni_datum() const { return obvykle_datum; }
	int julianske_cislo_dne() const { return jul_cislo_dne;}
	static int julianske_cislo_dne(int den, int mesic, int rok);
	static int julianske_cislo_dne(datum _datum) { return julianske_cislo_dne(_datum.den, _datum.mesic, _datum.rok); }
	static bool kontrola(int den, int mesic, int rok);
	static bool kontrola(datum _datum);
private:
	int jul_cislo_dne;
	datum obvykle_datum;
	static datum datum_z_jul_cisla_dne(int cislo_dne);
	bool vypočteno = false;
};
#endif // __DATUM__H__

