#include "datum.h"
#include <sstream>
using namespace std;

// Podle https://en.wikipedia.org/wiki/Julian_day

int Datum::julianske_cislo_dne(int den, int mesic, int rok)
{
	return (1461 * (rok + 4800 + (mesic - 14) / 12)) / 4 + (367 * (mesic - 2 - 12 * ((mesic - 14) / 12))) / 12 - (3 * ((rok + 4900 + (mesic - 14) / 12) / 100)) / 4 + den - 32075;
}


/* 
Podle https://en.wikipedia.org/wiki/Julian_day

int mod(int a, int b)
{
	return a % b;
}

Datum::datum datum_z_jul_cisla_dne(int J)
{
	int y = 4716;
	int j = 1401;
	int m = 2;
	int n = 12;
	int r = 4;
	int p = 1461;
	int v = 3;
	int u = 5;
	int s = 153;
	int w = 2;
	int B = 274277;
	int C = -38;
	int f = J + j + (((4 * J + B) / 146097) * 3) / 4 + C;
	int e = r * f + v;
	int g = mod(e, p) / r;
	int h = u * g + w;
	int den = (mod(h, s)) / u + 1;
	int měsíc = mod(h / s + m, n) + 1;
	int rok = (e / p) - y + (n + m - měsíc) / n;
	return Datum::datum{ den, měsíc, rok };
}*/

Datum::datum Datum::datum_z_jul_cisla_dne(int cislo_dne)
{
	int f = cislo_dne + 1401 + (((4 * cislo_dne + 274277) / 146097) * 3) / 4 - 38;
	int e = 4 * f + 3;
	int g = (e % 1461) / 4;
	int h = 5 * g + 2;
	int den = (h % 153) / 5 + 1;
	int mesic = (h / 153 + 2) % 12 + 1;
	int rok = (e / 1461) - 4716 + (12 + 2 - mesic) / 12;
	return datum{ den, mesic, rok };
}

Datum::Datum(int den, int mesic, int rok)
{
	if (kontrola(den, mesic, rok))
	{
		jul_cislo_dne = julianske_cislo_dne(den, mesic, rok);
		obvykle_datum = { den, mesic, rok };
	}
	else
	{
		jul_cislo_dne = 0;
		obvykle_datum = { 0,0,0 };
	}
}

bool Datum::prestupny_rok(int rok)
{
	return ((rok % 4 == 0) && (rok % 100 != 0)) || (rok % 400 == 0);
}

string Datum::na_retezec(format_data format) const
{ 
	ostringstream vystup;
	vystup << obvykle_datum.den << ". ";
	vystup << ((format == kratky || format == stredni)
		? to_string(obvykle_datum.mesic) + ". "s
		: jmeno_mesice[obvykle_datum.mesic] + " "s);
	vystup << ((format == kratky) ? obvykle_datum.rok % 1000 : obvykle_datum.rok);
	return vystup.str();
}

Datum Datum::zitra()
{
	return jul_cislo_dne + 1;
}

int Datum::cislo_dne_v_roce() const
{
	return jul_cislo_dne - Datum{ 31,12,obvykle_datum.rok - 1 }.jul_cislo_dne;
}

int Datum::den() const
{
	return obvykle_datum.den;
}

int Datum::mesic() const
{
	return obvykle_datum.mesic;
}

int Datum::rok() const
{
	return obvykle_datum.rok;
}

bool Datum::kontrola(Datum::datum dnes)
{
	if ((dnes.mesic <= 0) || (dnes.mesic > POCET_MESICU))
	{
		return false;
	}
	if ((dnes.den > 0) &&
		(dnes.den <= pocet_dnu_v_mesici[dnes.mesic]))
	{
		return true;
	}
	if (dnes.den == 29 && dnes.mesic == 2 && prestupny_rok(dnes.rok))
	{
		return true;
	}
	return false;
}

string Datum::den_v_tydnu(Datum kdy)
{
	int i = (kdy - zaklad) % POCET_DNU_V_TYDNU;
	if (i < 0) i += POCET_DNU_V_TYDNU;
	return jmeno_dne[i];
}

bool Datum::kontrola(int den, int mesic, int rok)
{
	return kontrola(Datum::datum{ den, mesic, rok });
}


const string Datum::jmeno_mesice[]{ "", "ledna", "února", "března",
		   "dubna", "května", "června", "července", "srpna",
		   "září", "října", "listopadu", "prosince" };

const int Datum::pocet_dnu_v_mesici[POCET_MESICU + 1] = { 0, 31, 28, 31, 30, 31,
					 30, 31, 31, 30, 31, 30, 31 };

const string Datum::jmeno_dne[]{ "neděle"s, "pondělí"s, "úterý"s, "středa"s, "čtvrtek"s, "pátek"s, "sobota"s };

const Datum Datum::zaklad{ 9, 4, 2023 };

Datum operator+(Datum d, int n)
{
	return d.julianske_cislo_dne() + n;
}

int Datum::operator[](int index) const
{
	switch (index)
	{
	case 1:
		return obvykle_datum.den;
	case 2:
		return obvykle_datum.mesic;
	case 3:
		return obvykle_datum.mesic;
	}
}

Datum operator-(Datum d, int n)
{
	return d.julianske_cislo_dne() - n;
}

int operator-(Datum d1, Datum d2)
{
	return d1.julianske_cislo_dne() - d2.julianske_cislo_dne();
}

