#ifndef __DATUM_H__
#define __DATUM_H__
#include <string>

using namespace std;

//int JuliánskéČísloDne(TDatum datum);
//TDatum DatumZJČD(int čísloDne);

enum format_data { kratky, stredni, dlouhy };

class Datum
{
public:
	struct datum
	{
		int den, mesic, rok;
		//auto operator<=>(const datum& d) const = default;
	};
	static const int POCET_MESICU = 12;
	static const int POCET_DNU_V_TYDNU = 7;
	static const int pocet_dnu_v_mesici[POCET_MESICU + 1];
	static const string jmeno_mesice[];
	static const string jmeno_dne[];
	Datum(int cisloDne) : jul_cislo_dne(cisloDne), obvykle_datum{ datum_z_jul_cisla_dne(cisloDne) }{}
	Datum(int den, int mesic, int rok);
	Datum(datum _datum) : Datum(_datum.den, _datum.mesic, _datum.rok) {}
	static bool prestupny_rok(int rok);
	string na_retezec(format_data format);
	Datum zitra();
	int cislo_dne_v_roce();
	int den();
	int mesic();
	int rok();
	int julianske_cislo_dne() { return jul_cislo_dne; }
	datum aktualni_datum() { return obvykle_datum; }
	static int julianske_cislo_dne(int den, int mesic, int rok);
	static int julianske_cislo_dne(datum _datum) { return julianske_cislo_dne(_datum.den, _datum.mesic, _datum.rok); }
	static bool kontrola(int den, int mesic, int rok);
	static bool kontrola(datum _datum);
	bool operator == (const Datum& d) const { return jul_cislo_dne == d.jul_cislo_dne; }
	auto operator <=>(const Datum& d) const { return jul_cislo_dne <=> d.jul_cislo_dne; }
	int operator[](int index);
	static string den_v_tydnu(Datum kdy);
private:
	int jul_cislo_dne;
	datum obvykle_datum;
	static datum datum_z_jul_cisla_dne(int cislo_dne);
	static const Datum zaklad;
};

Datum operator+(Datum d, int n);
Datum operator-(Datum d, int n);
int operator-(Datum d1, Datum d2);

#endif //__DATUM_H__
