#ifndef __DATUM_H__
#define __DATUM_H__
#include <string>
#include <sstream>
#include <stdexcept>

using namespace std;

//int JuliánskéČísloDne(TDatum datum);
//TDatum DatumZJČD(int čísloDne);

enum format_data { kratky, stredni, dlouhy };

template<class T>
class Datum
{
public:
	struct datum
	{
		int den, mesic, rok;
		//auto operator<=>(const datum& d) const = default;
	};
	static const int POCET_MESICU = 12;
	static const int POCET_DNU_V_TYDNU = 7;
	static const int pocet_dnu_v_mesici[POCET_MESICU + 1];
	static const string jmeno_mesice[];
	static const string jmeno_dne[];
	Datum(T cisloDne) : jul_cislo_dne(cisloDne), obvykle_datum{ datum_z_jul_cisla_dne(cisloDne) }{}
	Datum(int den, int mesic, int rok);
	Datum(datum _datum) : Datum(_datum.den, _datum.mesic, _datum.rok) {}
	static bool prestupny_rok(int rok);
	string na_retezec(format_data format);
	Datum zitra();
	int cislo_dne_v_roce();
	int den();
	int mesic();
	int rok();
	T julianske_cislo_dne() { return jul_cislo_dne; }
	datum aktualni_datum() { return obvykle_datum; }
	static T julianske_cislo_dne(int den, int mesic, int rok);
	static T julianske_cislo_dne(datum _datum) { return julianske_cislo_dne(_datum.den, _datum.mesic, _datum.rok); }
	static bool kontrola(int den, int mesic, int rok);
	static bool kontrola(datum _datum);
	bool operator == (const Datum& d) const { return jul_cislo_dne == d.jul_cislo_dne; }
	auto operator <=>(const Datum& d) const { return jul_cislo_dne <=> d.jul_cislo_dne; }
	int operator[](int index);
	static string den_v_tydnu(Datum kdy);
private:
	T jul_cislo_dne;
	datum obvykle_datum;
	static datum datum_z_jul_cisla_dne(T cislo_dne);
	static const Datum zaklad;
};

// Statické datové složky

template<class T>
const string Datum<T>::jmeno_dne[]{ "neděle"s, "pondělí"s, "úterý"s, "středa"s, "čtvrtek"s, "pátek"s, "sobota"s };

template<class T>
const string Datum<T>::jmeno_mesice[]{ "", "ledna", "února", "března",
		   "dubna", "května", "června", "července", "srpna",
		   "září", "října", "listopadu", "prosince" };

template<class T>
const int Datum<T>::pocet_dnu_v_mesici[POCET_MESICU + 1] = { 0, 31, 28, 31, 30, 31,
					 30, 31, 31, 30, 31, 30, 31 };

template<class T>
const Datum<T> Datum<T>::zaklad{ 9, 4, 2023 };

// Konstruktor
template<class T>
Datum<T>::Datum(int den, int mesic, int rok)
{
	if (kontrola(den, mesic, rok))
	{
		jul_cislo_dne = julianske_cislo_dne(den, mesic, rok);
		obvykle_datum = { den, mesic, rok };
	}
	else
	{
		throw invalid_argument("Parametry konstruktoru netvoří platné datum");
	}
}

// Metody

template<class T>
T Datum<T>::julianske_cislo_dne(int den, int mesic, int rok)
{
	return (1461 * (rok + 4800 + (mesic - 14) / 12)) / 4 + (367 * (mesic - 2 - 12 * ((mesic - 14) / 12))) / 12 - (3 * ((rok + 4900 + (mesic - 14) / 12) / 100)) / 4 + den - 32075;
}

template<class T>
Datum<T>::datum Datum<T>::datum_z_jul_cisla_dne(T cislo_dne)
{
	int f = cislo_dne + 1401 + (((4 * cislo_dne + 274277) / 146097) * 3) / 4 - 38;
	int e = 4 * f + 3;
	int g = (e % 1461) / 4;
	int h = 5 * g + 2;
	int den = (h % 153) / 5 + 1;
	int mesic = (h / 153 + 2) % 12 + 1;
	int rok = (e / 1461) - 4716 + (12 + 2 - mesic) / 12;
	return datum{ den, mesic, rok };
}

template<class T>
bool Datum<T>::prestupny_rok(int rok)
{
	return ((rok % 4 == 0) && (rok % 100 != 0)) || (rok % 400 == 0);
}

template<class T>
string Datum<T>::na_retezec(format_data format)
{
	ostringstream vystup;
	vystup << obvykle_datum.den << ". ";
	vystup << ((format == kratky || format == stredni)
		? to_string(obvykle_datum.mesic) + ". "s
		: jmeno_mesice[obvykle_datum.mesic] + " "s);
	vystup << ((format == kratky) ? obvykle_datum.rok % 1000 : obvykle_datum.rok);
	return vystup.str();
}

template<class T>
Datum<T> Datum<T>::zitra()
{
	return jul_cislo_dne + 1;
}

template<class T>
int Datum<T>::cislo_dne_v_roce()
{
	return jul_cislo_dne - Datum{ 31,12,obvykle_datum.rok - 1 }.jul_cislo_dne;
}

template<class T>
int Datum<T>::den()
{
	return obvykle_datum.den;
}

template<class T>
int Datum<T>::mesic()
{
	return obvykle_datum.mesic;
}

template<class T>
int Datum<T>::rok()
{
	return obvykle_datum.rok;
}

template<class T>
bool Datum<T>::kontrola(Datum<T>::datum dnes)
{
	if ((dnes.mesic <= 0) || (dnes.mesic > POCET_MESICU))
	{
		return false;
	}
	if ((dnes.den > 0) &&
		(dnes.den <= pocet_dnu_v_mesici[dnes.mesic]))
	{
		return true;
	}
	if (dnes.den == 29 && dnes.mesic == 2 && prestupny_rok(dnes.rok))
	{
		return true;
	}
	return false;
}

template<class T>
string Datum<T>::den_v_tydnu(Datum<T> kdy)
{
	int i = (kdy - zaklad) % POCET_DNU_V_TYDNU;
	if (i < 0) i += POCET_DNU_V_TYDNU;
	return jmeno_dne[i];
}

template<class T>
bool Datum<T>::kontrola(int den, int mesic, int rok)
{
	return kontrola(Datum::datum{ den, mesic, rok });
}

template<class T>
int Datum<T>::operator[](int index)
{
	switch (index)
	{
	case 1:
		return obvykle_datum.den;
	case 2:
		return obvykle_datum.mesic;
	case 3:
		return obvykle_datum.mesic;
	default:
		throw out_of_range("Index složky dne není v rozsahu 1 - 3");
	}
}

// Operátory deklarované jako obyčejné funkce

template<class T>
Datum<T> operator+(Datum<T> d, int n)
{
	return d.julianske_cislo_dne() + n;
}

template<class T>
Datum<T> operator-(Datum<T> d, int n)
{
	return d.julianske_cislo_dne() - n;
}

template<class T>
int operator-(Datum<T> d1, Datum<T> d2)
{
	return d1.julianske_cislo_dne() - d2.julianske_cislo_dne();
}

#endif