#include <iostream>
#include <ctype.h>
#include <fstream>
#include "strom.h"
using namespace std;

Uzel::Uzel(bool _otazka, string _text)
	: otazka(_otazka), text(_text), ano(nullptr), ne(nullptr)
{}

Strom::Strom()
{
	ifstream vstup(jmeno_souboru);
	if (vstup)
	{
		koren = nacti(vstup);
	}
	else
	{
		vytvor_implicitni_strom();
	}
}

bool Strom::ptej_se()
{
	aktualni = koren;
	while (aktualni->otazka)
	{
		cout << "Má to " << aktualni->text << "?" << endl;
		aktualni = odpoved_je_ano() ? aktualni->ano : aktualni->ne;
	}
	cout << "Je to " << aktualni->text << "?" << endl;
	return odpoved_je_ano();
}

Strom::~Strom()
{
	uloz();
	smaz_podstrom(koren);
}

Uzel* Strom::nacti(ifstream& vstup)
{
	string text;
	bool otazka;
	vstup >> text >> otazka;
	Uzel* vysledek = new Uzel(otazka, text);
	if (otazka)
	{
		vysledek->ano = nacti(vstup);
		vysledek->ne = nacti(vstup);
	}
	return vysledek;
}

void Strom::smaz_podstrom(Uzel* koren_podstromu)
{
	if (koren_podstromu->ano != nullptr)smaz_podstrom(koren_podstromu->ano);
	if (koren_podstromu->ne != nullptr)smaz_podstrom(koren_podstromu->ne);
	delete koren_podstromu;
}

void Strom::konverzace()
{
	cout << "\nMohu hádat zvíře? ";
	if (odpoved_je_ne())
	{
		return;
	}
	while (true)
	{
		bool uhodnuto = ptej_se();
		if (!uhodnuto) zjisti_spravnou_odpoved();
		cout << "Mám hádat další zvíře? ";
		if (odpoved_je_ne())
		{
			return;
		}
	}
}

bool Strom::odpoved_je_ano()
{
	string odpoved;
	cin >> odpoved;
	return tolower(odpoved[0]) == 'a';
}


void Strom::zjisti_spravnou_odpoved()
{
	string nove_zvire;
	string rozlisovaci_znak;
	bool nove_to_ma;
	zjisti_nove_zvire(nove_zvire, rozlisovaci_znak, nove_to_ma);
	pridej_nove_zvire(nove_zvire, rozlisovaci_znak, nove_to_ma);

}

void Strom::zjisti_nove_zvire(string& nove_zvire, string& rozlisovaci_znak, bool& ma_ho)
{
	cout << "A co to tedy je ? ";
	cin >> nove_zvire;
	cout << "Čím se liší " << aktualni->text << " a " << nove_zvire << "? " << endl;
	cin >> rozlisovaci_znak;
	cout << nove_zvire << " má " << rozlisovaci_znak << "? (prosím ano - ne) " << endl;
	ma_ho = odpoved_je_ano();
}

void Strom::pridej_nove_zvire(string& nove_zvire, string& znak, bool& nove_to_ma)
{
	string puvodni_zvire = aktualni->text;
	aktualni->otazka = true;
	aktualni->text = znak;
	if (nove_to_ma)
	{
		aktualni->ano = new Uzel(false, nove_zvire);
		aktualni->ne = new Uzel(false, puvodni_zvire);
	}
	else
	{
		aktualni->ne = new Uzel(false, nove_zvire);
		aktualni->ano = new Uzel(false, puvodni_zvire);
	}
}

void Strom::uloz_podstrom(Uzel* korinek, ofstream& vystup)
{
	vystup << korinek->text << " " << korinek->otazka << endl;
	if (korinek->otazka)
	{
		uloz_podstrom(korinek->ano, vystup);
		uloz_podstrom(korinek->ne, vystup);
	}
}

void Strom::vytvor_implicitni_strom()
{
	koren = new Uzel(true, "rohy"s);
	koren->ano = new Uzel(false, "koza"s);
	koren->ne = new Uzel(false, "žába"s);
}

void Strom::uloz()
{
	ofstream vystup(jmeno_souboru);
	if (!vystup)
	{
		cerr << "Nepodařilo se uložit strom otázek a odpovědí." << endl;
		return;
	}
	uloz_podstrom(koren, vystup);
}